/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.jdbc;

import io.debezium.DebeziumException;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.jdbc.BinlogFieldReader;
import io.debezium.connector.binlog.jdbc.ConnectionConfiguration;
import io.debezium.connector.mariadb.gtid.MariaDbGtidSet;
import java.sql.SQLException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbConnection
extends BinlogConnectorConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbConnection.class);

    public MariaDbConnection(ConnectionConfiguration configuration, BinlogFieldReader fieldReader) {
        super(configuration, fieldReader);
    }

    public boolean isGtidModeEnabled() {
        return true;
    }

    public GtidSet knownGtidSet() {
        try {
            return (GtidSet)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_BINLOG_POS'", rs -> {
                if (rs.next()) {
                    return new MariaDbGtidSet(rs.getString(2));
                }
                return new MariaDbGtidSet("");
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while looking at GTID_BINLOG_POS: ", (Throwable)e);
        }
    }

    public GtidSet subtractGtidSet(GtidSet set1, GtidSet set2) {
        return set1.subtract(set2);
    }

    public GtidSet purgedGtidSet() {
        return new MariaDbGtidSet("");
    }

    public GtidSet filterGtidSet(Predicate<String> gtidSourceFilter, String offsetGtids, GtidSet availableServerGtidSet, GtidSet purgedServerGtidSet) {
        String gtidStr = offsetGtids;
        if (gtidStr == null) {
            return null;
        }
        LOGGER.info("Attempting to generate a filtered GTID set");
        LOGGER.info("GTID set from previous recorded offset: {}", (Object)gtidStr);
        MariaDbGtidSet filteredGtidSet = new MariaDbGtidSet(gtidStr);
        if (gtidSourceFilter != null) {
            filteredGtidSet = (MariaDbGtidSet)filteredGtidSet.retainAll(gtidSourceFilter);
            LOGGER.info("GTID set after applying GTID source includes/excludes to previous recorded offset: {}", (Object)filteredGtidSet);
        }
        LOGGER.info("GTID set available on server: {}", (Object)availableServerGtidSet);
        MariaDbGtidSet knownGtidSet = filteredGtidSet;
        LOGGER.info("Using first available positions for new GTID channels");
        GtidSet relevantAvailableServerGtidSet = gtidSourceFilter != null ? availableServerGtidSet.retainAll(gtidSourceFilter) : availableServerGtidSet;
        LOGGER.info("Relevant GTID set available on server: {}", (Object)relevantAvailableServerGtidSet);
        GtidSet mergedGtidSet = relevantAvailableServerGtidSet.retainAll(serverId -> {
            MariaDbGtidSet.MariaDbGtid compliantGtid = MariaDbGtidSet.MariaDbGtid.parse(serverId + "-0");
            return knownGtidSet.forGtidStream(compliantGtid) != null;
        }).with(purgedServerGtidSet).with((GtidSet)filteredGtidSet);
        LOGGER.info("Final merged GTID set to use when connecting to MariaDB: {}", (Object)mergedGtidSet);
        return mergedGtidSet;
    }
}

