/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.connector.binlog.BinlogReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.mariadb.gtid.MariaDbGtidSet;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbReadOnlyIncrementalSnapshotContext<T>
extends BinlogReadOnlyIncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbReadOnlyIncrementalSnapshotContext.class);
    private MariaDbGtidSet previousLowWatermark;
    private MariaDbGtidSet previousHighWatermark;
    private MariaDbGtidSet lowWatermark;
    private MariaDbGtidSet highWatermark;

    public MariaDbReadOnlyIncrementalSnapshotContext() {
        this(true);
    }

    public MariaDbReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    public boolean updateWindowState(OffsetContext offsetContext) {
        String currentGtid = this.getCurrentGtid(offsetContext);
        if (!this.windowOpened && this.lowWatermark != null) {
            boolean pastLowWatermark;
            boolean bl = pastLowWatermark = !this.lowWatermark.contains(currentGtid);
            if (pastLowWatermark) {
                LOGGER.debug("Current gtid {}, low watermark {}", (Object)currentGtid, (Object)this.lowWatermark);
                this.windowOpened = true;
            }
        }
        if (this.windowOpened && this.highWatermark != null) {
            boolean pastHighWatermark;
            boolean bl = pastHighWatermark = !this.highWatermark.contains(currentGtid);
            if (pastHighWatermark) {
                LOGGER.debug("Current gtid {}, high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
                this.closeWindow();
                return true;
            }
        }
        return false;
    }

    public boolean hasServerIdentifierChanged() {
        return this.serverStreamSetChanged();
    }

    public boolean reachedHighWatermark(String currentGtid) {
        long maxSequenceId;
        if (this.highWatermark == null) {
            return false;
        }
        if (currentGtid == null) {
            return true;
        }
        MariaDbGtidSet.MariaDbGtid currentMariaDbGtid = MariaDbGtidSet.parse(currentGtid);
        MariaDbGtidSet.MariaDbStreamSet streamSet = this.getStreamSetForGtid(currentMariaDbGtid);
        if (streamSet != null && (maxSequenceId = streamSet.stream().mapToLong(MariaDbGtidSet.MariaDbGtid::getSequence).max().getAsLong()) <= currentMariaDbGtid.getSequence()) {
            LOGGER.debug("Gtid {} reached high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
            return true;
        }
        return false;
    }

    public boolean watermarksChanged() {
        return !this.previousLowWatermark.equals(this.lowWatermark) || !this.previousHighWatermark.equals(this.highWatermark);
    }

    public void closeWindow() {
        this.windowOpened = false;
        this.previousHighWatermark = this.highWatermark;
        this.highWatermark = null;
        this.previousLowWatermark = this.lowWatermark;
        this.lowWatermark = null;
    }

    public void setLowWatermark(GtidSet lowWatermark) {
        this.lowWatermark = (MariaDbGtidSet)lowWatermark;
    }

    public void setHighWatermark(GtidSet highWatermark) {
        this.highWatermark = (MariaDbGtidSet)highWatermark.subtract((GtidSet)this.lowWatermark);
    }

    private MariaDbGtidSet.MariaDbStreamSet getStreamSetForGtid(MariaDbGtidSet.MariaDbGtid currentGtid) {
        return this.highWatermark.isEmpty() ? this.lowWatermark.forGtidStream(currentGtid) : this.highWatermark.forGtidStream(currentGtid);
    }

    public boolean serverStreamSetChanged() {
        return !this.highWatermark.isEmpty();
    }

    public static <U> MariaDbReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets) {
        return MariaDbReadOnlyIncrementalSnapshotContext.load(offsets, true);
    }

    public static <U> MariaDbReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        MariaDbReadOnlyIncrementalSnapshotContext context = new MariaDbReadOnlyIncrementalSnapshotContext(useCatalogBeforeSchema);
        MariaDbReadOnlyIncrementalSnapshotContext.init(context, offsets);
        return context;
    }
}

