/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchemaTest;
import io.debezium.connector.binlog.jdbc.BinlogValueConverters;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbDatabaseSchema;
import io.debezium.connector.mariadb.MariaDbOffsetContext;
import io.debezium.connector.mariadb.MariaDbPartition;
import io.debezium.connector.mariadb.jdbc.MariaDbValueConverters;
import io.debezium.connector.mariadb.util.MariaDbValueConvertersFactory;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.Set;
import org.assertj.core.api.Assertions;

public class DatabaseSchemaTest
extends BinlogDatabaseSchemaTest<MariaDbConnectorConfig, MariaDbDatabaseSchema, MariaDbPartition, MariaDbOffsetContext> {
    protected MariaDbConnectorConfig getConnectorConfig(Configuration config) {
        config = ((Configuration.Builder)config.edit().with(AbstractSchemaHistory.INTERNAL_PREFER_DDL, true)).build();
        return new MariaDbConnectorConfig(config);
    }

    protected MariaDbDatabaseSchema getSchema(Configuration config) {
        this.connectorConfig = this.getConnectorConfig(config);
        return new MariaDbDatabaseSchema((MariaDbConnectorConfig)this.connectorConfig, (MariaDbValueConverters)new MariaDbValueConvertersFactory().create(RelationalDatabaseConnectorConfig.DecimalHandlingMode.PRECISE, TemporalPrecisionMode.ADAPTIVE, BinlogConnectorConfig.BigIntUnsignedHandlingMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, BinlogValueConverters::adjustTemporal, CommonConnectorConfig.EventConvertingFailureHandlingMode.WARN), (TopicNamingStrategy)DefaultTopicNamingStrategy.create((CommonConnectorConfig)this.connectorConfig), SchemaNameAdjuster.create(), false);
    }

    protected MariaDbPartition initializePartition(MariaDbConnectorConfig connectorConfig, Configuration taskConfig) {
        Set partitions = new MariaDbPartition.Provider((BinlogConnectorConfig)connectorConfig, taskConfig).getPartitions();
        Assertions.assertThat((Iterable)partitions).hasSize(1);
        return (MariaDbPartition)partitions.iterator().next();
    }

    protected MariaDbOffsetContext initializeOffset(MariaDbConnectorConfig connectorConfig) {
        return MariaDbOffsetContext.initial((MariaDbConnectorConfig)connectorConfig);
    }
}

