/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.jdbc;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.binlog.jdbc.BinlogConnectionConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;

public class MariaDbConnectionConfiguration
extends BinlogConnectionConfiguration {
    private static final String JDBC_PROPERTY_MARIADB_TIME_ZONE = "timezone";
    private static final String URL_PATTERN = "jdbc:mariadb://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}";

    public MariaDbConnectionConfiguration(Configuration configuration) {
        super(configuration);
    }

    protected String getConnectionTimeZonePropertyName() {
        return JDBC_PROPERTY_MARIADB_TIME_ZONE;
    }

    protected String resolveConnectionTimeZone(Configuration configuration) {
        return Strings.defaultIfBlank((String)configuration.getString(JDBC_PROPERTY_MARIADB_TIME_ZONE), (String)"auto");
    }

    protected JdbcConnection.ConnectionFactory createFactory(Configuration configuration) {
        return JdbcConnection.patternBasedFactory((String)URL_PATTERN, (Field[])new Field[0]);
    }

    public String getUrlPattern() {
        return URL_PATTERN;
    }
}

