/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr.listener;

import io.debezium.connector.mariadb.antlr.MariaDbAntlrDdlParser;
import io.debezium.connector.mariadb.antlr.listener.ColumnDefinitionParserListener;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class TableCommonParserListener
extends MariaDBParserBaseListener {
    protected final MariaDbAntlrDdlParser parser;
    protected final List<ParseTreeListener> listeners;
    protected TableEditor tableEditor;
    protected ColumnDefinitionParserListener columnDefinitionListener;

    public TableCommonParserListener(MariaDbAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterColumnDeclaration(MariaDBParser.ColumnDeclarationContext ctx) {
        this.parser.runIfNotNull(() -> {
            MariaDBParser.UidContext fullColumnNameContext = ctx.uid();
            String columnName = this.parser.parseName(fullColumnNameContext);
            ColumnEditor columnEditor = Column.editor().name(columnName);
            if (this.columnDefinitionListener == null) {
                this.columnDefinitionListener = new ColumnDefinitionParserListener(this.tableEditor, columnEditor, this.parser, this.listeners);
                this.listeners.add((ParseTreeListener)this.columnDefinitionListener);
            } else {
                this.columnDefinitionListener.setColumnEditor(columnEditor);
            }
        }, this.tableEditor);
        super.enterColumnDeclaration(ctx);
    }

    public void exitColumnDeclaration(MariaDBParser.ColumnDeclarationContext ctx) {
        this.parser.runIfNotNull(() -> this.tableEditor.addColumn(this.columnDefinitionListener.getColumn()), new Object[]{this.tableEditor, this.columnDefinitionListener});
        super.exitColumnDeclaration(ctx);
    }

    public void enterPrimaryKeyTableConstraint(MariaDBParser.PrimaryKeyTableConstraintContext ctx) {
        this.parser.runIfNotNull(() -> this.parser.parsePrimaryIndexColumnNames(ctx.indexColumnNames(), this.tableEditor), this.tableEditor);
        super.enterPrimaryKeyTableConstraint(ctx);
    }

    public void enterUniqueKeyTableConstraint(MariaDBParser.UniqueKeyTableConstraintContext ctx) {
        this.parser.runIfNotNull(() -> {
            if (!this.tableEditor.hasPrimaryKey() && this.parser.isTableUniqueIndexIncluded(ctx.indexColumnNames(), this.tableEditor)) {
                this.parser.parseUniqueIndexColumnNames(ctx.indexColumnNames(), this.tableEditor);
            }
        }, this.tableEditor);
        super.enterUniqueKeyTableConstraint(ctx);
    }
}

