/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.binlog.charset.BinlogCharsetRegistry;
import io.debezium.connector.binlog.jdbc.BinlogSystemVariables;
import io.debezium.connector.mariadb.antlr.listener.MariaDbAntlrDdlParserListener;
import io.debezium.connector.mariadb.jdbc.MariaDbValueConverters;
import io.debezium.ddl.parser.mariadb.generated.MariaDBLexer;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class MariaDbAntlrDdlParser
extends AntlrDdlParser<MariaDBLexer, MariaDBParser> {
    private final ConcurrentHashMap<String, String> charsetNameForDatabase = new ConcurrentHashMap();
    private final MariaDbValueConverters converters;
    private final Tables.TableFilter tableFilter;
    private final BinlogCharsetRegistry charsetRegistry;

    public MariaDbAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MariaDbAntlrDdlParser(MariaDbValueConverters valueConverters) {
        this(valueConverters, Tables.TableFilter.includeAll());
    }

    public MariaDbAntlrDdlParser(MariaDbValueConverters valueConverters, Tables.TableFilter tableFilter) {
        this(true, false, true, valueConverters, tableFilter, null);
    }

    public MariaDbAntlrDdlParser(boolean throwWerrorsFromTreeWalk, boolean includeViews, boolean includeComments, MariaDbValueConverters valueConverters, Tables.TableFilter tableFilter, BinlogCharsetRegistry charsetRegistry) {
        super(throwWerrorsFromTreeWalk, includeViews, includeComments);
        this.systemVariables = new BinlogSystemVariables();
        this.converters = valueConverters;
        this.tableFilter = tableFilter;
        this.charsetRegistry = charsetRegistry;
    }

    protected ParseTree parseTree(MariaDBParser parser) {
        return parser.root();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MariaDbAntlrDdlParserListener(this);
    }

    protected MariaDBLexer createNewLexerInstance(CharStream charStreams) {
        return new MariaDBLexer(charStreams);
    }

    protected MariaDBParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MariaDBParser((TokenStream)commonTokenStream);
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return new BinlogSystemVariables();
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{222}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{222, 238}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{223}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{233}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{234}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{235}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{236}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{231}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{519}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{519, 238}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{224}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{222, 226}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{223, 226}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{233, 226}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{234, 226}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{235, 226}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{236, 226}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{519, 226}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{224, 226}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{26}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{26, 238})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{225, 223}).setSuffixTokens(new Integer[]{226}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{225, 26}).setSuffixTokens(new Integer[]{226}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{225, 222}).setSuffixTokens(new Integer[]{226}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{519, 223}).setSuffixTokens(new Integer[]{226})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{225, 222, 238}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{225, 26, 238})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, new Integer[]{196}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{201}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{197}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{202}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{198}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{203}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{199}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{200}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{206}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{204}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{207}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{205}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(7, new Integer[]{208}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{209}).setSuffixTokens(new Integer[]{210, 614, 183, 195}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{213}).setSuffixTokens(new Integer[]{210, 614, 183, 195}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{211}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{212}).setSuffixTokens(new Integer[]{614, 183, 195}), new DataTypeResolver.DataTypeEntry(3, new Integer[]{214}).setSuffixTokens(new Integer[]{614, 183, 195}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{215}).setSuffixTokens(new Integer[]{614, 183, 195}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{431}).setSuffixTokens(new Integer[]{614, 183, 195}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, new Integer[]{216}).setSuffixTokens(new Integer[]{614, 183, 195}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, new Integer[]{346}).setDefaultLengthDimension(1), new DataTypeResolver.DataTypeEntry(92, new Integer[]{218}), new DataTypeResolver.DataTypeEntry(2014, new Integer[]{219}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{220}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{226}), new DataTypeResolver.DataTypeEntry(-3, new Integer[]{227}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{229}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{221})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, new Integer[]{217}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{228}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{230}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{232}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{348}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{349}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{239})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{237}).setSuffixTokens(new Integer[]{226}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{154}).setSuffixTokens(new Integer[]{226})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, new Integer[]{810}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{811}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{813}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{814}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{815}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{816}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{817}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{818}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{466}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{812})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, new Integer[]{231}).setSuffixTokens(new Integer[]{227})));
        dataTypeResolverBuilder.registerDataTypes(MariaDBParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, new Integer[]{231}).setSuffixTokens(new Integer[]{223})));
        return dataTypeResolverBuilder.build();
    }

    public BinlogCharsetRegistry getCharsetRegistry() {
        return this.charsetRegistry;
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MariaDBParser.UidContext uidContext) {
        return this.withoutQuotes((ParserRuleContext)uidContext);
    }

    public TableId parseQualifiedTableId(MariaDBParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MariaDbAntlrDdlParser.isQuote((char)c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MariaDBParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : (indexColumnNameContext.STRING_LITERAL() != null ? MariaDbAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText()) : indexColumnNameContext.expression().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && !ce.defaultValueExpression().isPresent()) {
                    ce.unsetDefaultValueExpression();
                }
                tableEditor.addColumn(ce.create());
            }
            return column != null ? column.name() : columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public void parseUniqueIndexColumnNames(MariaDBParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<Column> indexColumns = this.getIndexColumns(indexColumnNamesContext, tableEditor);
        if (indexColumns.stream().filter(col -> Objects.isNull(col) || col.isOptional()).count() > 0L) {
            this.logger.warn("Skip to set unique index columns {} to primary key which including optional columns", indexColumns);
        } else {
            tableEditor.setPrimaryKeyNames(indexColumns.stream().map(Column::name).collect(Collectors.toList()));
        }
    }

    public boolean isTableUniqueIndexIncluded(MariaDBParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        return this.getIndexColumns(indexColumnNamesContext, tableEditor).stream().filter(Objects::isNull).count() == 0L;
    }

    private List<Column> getIndexColumns(MariaDBParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        return indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : (indexColumnNameContext.STRING_LITERAL() != null ? MariaDbAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText()) : indexColumnNameContext.expression().getText());
            return tableEditor.columnWithName(columnName);
        }).collect(Collectors.toList());
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MariaDbAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replace("''", "'");
    }

    public MariaDbValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MariaDBParser.CharsetNameContext charsetNode, MariaDBParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MariaDbAntlrDdlParser.withoutQuotes((String)charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MariaDbAntlrDdlParser.withoutQuotes((String)collationNode.getText()).toLowerCase();
            for (int index = 0; index < this.charsetRegistry.getCharsetMapSize(); ++index) {
                if (!collationName.equals(this.charsetRegistry.getCollationNameForCollationIndex(Integer.valueOf(index)))) continue;
                charsetName = this.charsetRegistry.getCharsetNameForCollationIndex(Integer.valueOf(index));
                break;
            }
        }
        return charsetName;
    }

    public void signalAlterTable(TableId id, TableId previousId, MariaDBParser.RenameTableClauseContext ctx) {
        MariaDBParser.RenameTableContext parent = (MariaDBParser.RenameTableContext)ctx.getParent();
        Interval interval = new Interval(ctx.getParent().start.getStartIndex(), ((MariaDBParser.RenameTableClauseContext)parent.renameTableClause().get((int)0)).start.getStartIndex() - 1);
        String prefix = ctx.getParent().start.getInputStream().getText(interval);
        this.signalAlterTable(id, previousId, prefix + MariaDbAntlrDdlParser.getText((ParserRuleContext)ctx));
    }
}

