/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.DebeziumException;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogReadOnlyIncrementalSnapshotChangeEventSource;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbOffsetContext;
import io.debezium.connector.mariadb.MariaDbPartition;
import io.debezium.connector.mariadb.gtid.MariaDbGtidSet;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.function.Consumer;

public class MariaDbReadOnlyIncrementalSnapshotChangeEventSource
extends BinlogReadOnlyIncrementalSnapshotChangeEventSource<MariaDbPartition, MariaDbOffsetContext> {
    public MariaDbReadOnlyIncrementalSnapshotChangeEventSource(MariaDbConnectorConfig connectorConfig, JdbcConnection jdbcConnection, EventDispatcher<MariaDbPartition, TableId> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener<MariaDbPartition> progressListener, DataChangeEventListener<MariaDbPartition> dataChangeEventListener, NotificationService<MariaDbPartition, MariaDbOffsetContext> notificationService) {
        super((BinlogConnectorConfig)connectorConfig, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener, notificationService);
    }

    protected void getExecutedGtidSet(Consumer<GtidSet> watermark) {
        try {
            this.jdbcConnection.query("SHOW GLOBAL VARIABLES LIKE 'GTID_BINLOG_POS'", rs -> {
                if (rs.next()) {
                    if (rs.getMetaData().getColumnCount() > 0) {
                        String gtidSet = rs.getString(2);
                        watermark.accept(new MariaDbGtidSet(gtidSet));
                    } else {
                        throw new UnsupportedOperationException("Need to add support for executed GTIDs for versions prior to 5.6.5");
                    }
                }
            });
            this.jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
    }
}

