/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.gtid.GtidSetFactory;
import io.debezium.connector.mariadb.MariaDbConnector;
import io.debezium.connector.mariadb.MariaDbSourceInfoStructMaker;
import io.debezium.connector.mariadb.Module;
import io.debezium.connector.mariadb.charset.MariaDbCharsetRegistryServiceProvider;
import io.debezium.connector.mariadb.gtid.MariaDbGtidSetFactory;
import io.debezium.connector.mariadb.history.MariaDbHistoryRecordComparator;
import io.debezium.function.Predicates;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.service.spi.ServiceProvider;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbConnectorConfig
extends BinlogConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbConnectorConfig.class);
    private static final int DEFAULT_NON_STREAMING_FETCH_SIZE = 1;
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(MariaDbSourceInfoStructMaker.class.getName());
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.MINIMAL).withImportance(ConfigDef.Importance.LOW).withDescription("Controls how long the connector holds onto the global read lock while it is performing a snapshot. The default is 'minimal', meaning the connector holds the global read lock (and thus prevents updates) for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this can be done using the snapshot process' REPEATABLE READ transaction isolation even when the lock is no longer held and other operations are updating the database. However, in some cases it may be desirable to block all writes for the entire duration of the snapshot; in such cases set this to 'extended'. Using a value of 'none' will prevent the connector from acquiring any table locks during the snapshot process. This mode can only be used in combination with snapshot.mode values of 'schema_only' or 'schema_only_recovery' and is only safe to use if no schema changes are happening while the snapshot is taken.").withValidation(new Field.Validator[]{MariaDbConnectorConfig::validateSnapshotLockingMode});
    public static final Field GTID_SOURCE_INCLUDES = BinlogConnectorConfig.GTID_SOURCE_INCLUDES.withDescription("The source domain IDs used to include GTID ranges when determining the starting position in the MariaDB server's binlog.");
    public static final Field GTID_SOURCE_EXCLUDES = BinlogConnectorConfig.GTID_SOURCE_EXCLUDES.withDescription("The source domain IDs used to exclude GTID ranges when determining the starting position in the MariaDB server's binlog.");
    private static final ConfigDefinition CONFIG_DEFINITION = BinlogConnectorConfig.CONFIG_DEFINITION.edit().name("MariaDB").excluding(new Field[]{BinlogConnectorConfig.GTID_SOURCE_INCLUDES, BinlogConnectorConfig.GTID_SOURCE_EXCLUDES}).connector(new Field[]{SNAPSHOT_LOCKING_MODE}).events(new Field[]{GTID_SOURCE_INCLUDES, GTID_SOURCE_EXCLUDES, SOURCE_INFO_STRUCT_MAKER}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final GtidSetFactory gtidSetFactory = new MariaDbGtidSetFactory();
    private final Predicate<String> gtidSourceFilter;
    private final SnapshotLockingMode snapshotLockingMode;
    private final BinlogConnectorConfig.SnapshotLockingStrategy snapshotLockingStrategy;

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public MariaDbConnectorConfig(Configuration config) {
        super(MariaDbConnector.class, config, 1);
        String gtidIncludes = config.getString(GTID_SOURCE_INCLUDES);
        String gtidExcludes = config.getString(GTID_SOURCE_EXCLUDES);
        this.gtidSourceFilter = gtidIncludes != null ? Predicates.includes((String)gtidIncludes) : (gtidExcludes != null ? Predicates.excludes((String)gtidExcludes) : null);
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE));
        this.snapshotLockingStrategy = new MariaDbSnapshotLockingStrategy(this.snapshotLockingMode);
        this.getServiceRegistry().registerServiceProvider((ServiceProvider)new MariaDbCharsetRegistryServiceProvider());
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    public Predicate<String> getGtidSourceFilter() {
        return this.gtidSourceFilter;
    }

    public GtidSetFactory getGtidSetFactory() {
        return this.gtidSetFactory;
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new MariaDbHistoryRecordComparator(this.gtidSourceFilter, this.getGtidSetFactory());
    }

    protected BinlogConnectorConfig.SnapshotLockingStrategy getSnapshotLockingStrategy() {
        return this.snapshotLockingStrategy;
    }

    public Optional<SnapshotLockingMode> getSnapshotLockingMode() {
        return Optional.of(this.snapshotLockingMode);
    }

    private static int validateSnapshotLockingMode(Configuration config, Field field, Field.ValidationOutput problems) {
        SnapshotLockingMode lockingModeValue;
        if (config.hasKey(SNAPSHOT_LOCKING_MODE.name()) && (lockingModeValue = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE))) == null) {
            problems.accept(SNAPSHOT_LOCKING_MODE, (Object)lockingModeValue, "Must be a valid snapshot.locking.mode value");
            return 1;
        }
        return 0;
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        EXTENDED("extended"),
        MINIMAL("minimal"),
        NONE("none"),
        CUSTOM("custom");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean usesMinimalLocking() {
            return this.value.equals(SnapshotLockingMode.MINIMAL.value);
        }

        public boolean usesLocking() {
            return !this.value.equals(SnapshotLockingMode.NONE.value);
        }

        public boolean flushResetsIsolationLevel() {
            return true;
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static class MariaDbSnapshotLockingStrategy
    implements BinlogConnectorConfig.SnapshotLockingStrategy {
        public final SnapshotLockingMode snapshotLockingMode;

        public MariaDbSnapshotLockingStrategy(SnapshotLockingMode snapshotLockingMode) {
            this.snapshotLockingMode = snapshotLockingMode;
        }

        public boolean isLockingEnabled() {
            return this.snapshotLockingMode.usesLocking();
        }

        public boolean isMinimalLockingEnabled() {
            return this.snapshotLockingMode.usesMinimalLocking();
        }

        public boolean isIsolationLevelResetOnFlush() {
            return this.snapshotLockingMode.flushResetsIsolationLevel();
        }
    }
}

