/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import io.debezium.function.BlockingConsumer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public interface BufferedBlockingConsumer<T>
extends BlockingConsumer<T> {
    public void close(Function<T, T> var1) throws InterruptedException;

    public static <T> BufferedBlockingConsumer<T> bufferLast(final BlockingConsumer<T> delegate) {
        return new BufferedBlockingConsumer<T>(){
            private final AtomicReference<T> last = new AtomicReference();

            @Override
            public void accept(T t) throws InterruptedException {
                Object previous = this.last.getAndSet(t);
                if (previous != null) {
                    delegate.accept(previous);
                }
            }

            @Override
            public synchronized void close(Function<T, T> function) throws InterruptedException {
                Object previous = this.last.get();
                if (previous != null) {
                    try {
                        delegate.accept(function.apply(previous));
                    }
                    finally {
                        this.last.set(null);
                    }
                }
            }
        };
    }
}

