/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.charset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import io.debezium.connector.binlog.charset.BinlogCharsetRegistry;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class MariaDbCharsetRegistry
implements BinlogCharsetRegistry {
    private static final String CHARSET_MAPPINGS = "charset_mappings.json";
    private static final int MAP_SIZE = 1024;
    private final List<String> collationIndexToCollationName = new ArrayList<Object>(Collections.nCopies(1024, null));
    private final Map<Integer, CharacterSetMapping> collationIndexToCharacterSet = new TreeMap<Integer, CharacterSetMapping>();
    private final Map<String, CharacterSetMapping> characterSetNameToCharacterSet = new HashMap<String, CharacterSetMapping>();

    public MariaDbCharsetRegistry() {
        this.loadCharacterSetMappingsFromFileResource();
    }

    public int getCharsetMapSize() {
        return 1024;
    }

    public String getCollationNameForCollationIndex(Integer collationIndex) {
        String newValue = null;
        if (!Objects.isNull(collationIndex) && MariaDbCharsetRegistry.isWithinRange(collationIndex)) {
            newValue = this.collationIndexToCollationName.get(collationIndex);
        }
        return newValue;
    }

    public String getCharsetNameForCollationIndex(Integer collationIndex) {
        CharacterSetMapping mapping;
        String newValue = null;
        if (!Objects.isNull(collationIndex) && !Objects.isNull(mapping = this.collationIndexToCharacterSet.get(collationIndex))) {
            newValue = mapping.name;
        }
        return newValue;
    }

    public String getJavaEncodingForCharSet(String characterSetName) {
        CharacterSetMapping mapping = this.characterSetNameToCharacterSet.get(characterSetName);
        if (!Objects.isNull(mapping)) {
            return mapping.getFirstEncoding();
        }
        return null;
    }

    private void loadCharacterSetMappingsFromFileResource() {
        try (InputStream stream = MariaDbCharsetRegistry.class.getClassLoader().getResourceAsStream(CHARSET_MAPPINGS);){
            ObjectMapper mapper = new ObjectMapper();
            CharacterSetMappings mappings = (CharacterSetMappings)mapper.readValue(stream, CharacterSetMappings.class);
            this.loadCharacterSetMappings(mappings.characterSets);
            this.loadCollationMappings(mappings.collations);
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to load character set mappings", (Throwable)e);
        }
    }

    private void loadCharacterSetMappings(List<CharacterSetMapping> characterSetMappings) {
        for (CharacterSetMapping charsetMapping : characterSetMappings) {
            String characterSetName = charsetMapping.name;
            this.characterSetNameToCharacterSet.put(characterSetName, charsetMapping);
            if (Objects.isNull(charsetMapping.aliases)) continue;
            for (String alias : charsetMapping.aliases) {
                this.characterSetNameToCharacterSet.put(alias, charsetMapping);
            }
        }
    }

    private void loadCollationMappings(List<CollationMapping> collationMappings) {
        for (CollationMapping collation : collationMappings) {
            CharacterSetMapping mapping = this.characterSetNameToCharacterSet.get(collation.charSetName);
            this.collationIndexToCollationName.set(collation.index, collation.collations.get(0));
            this.collationIndexToCharacterSet.put(collation.index, mapping);
        }
    }

    private static boolean isWithinRange(int value) {
        return value > 0 && value < 1024;
    }

    private static class CharacterSetMapping {
        private static final String UTF8 = "UTF-8";
        private static final String CP1252 = "Cp1252";
        String name;
        int multiByteLength;
        int priority;
        List<String> encodings;
        List<String> aliases;
        String comment;

        @JsonCreator
        CharacterSetMapping(@JsonProperty(value="name") String name, @JsonProperty(value="mblen") int multiByteLength, @JsonProperty(value="priority") int priority, @JsonProperty(value="encodings") List<String> encodings, @JsonProperty(value="aliases") List<String> aliases, @JsonProperty(value="comment") String comment) {
            this.name = name;
            this.multiByteLength = multiByteLength;
            this.priority = priority;
            this.encodings = new ArrayList<String>();
            this.aliases = Objects.isNull(aliases) ? new ArrayList() : aliases;
            this.comment = comment;
            this.addEncodings(encodings);
        }

        private String getFirstEncoding() {
            return this.encodings.get(0);
        }

        private void addEncodings(List<String> encodings) {
            for (String encoding : encodings) {
                try {
                    Charset charset = Charset.forName(encoding);
                    this.addEncodingMapping(charset.name());
                    charset.aliases().forEach(this::addEncodingMapping);
                }
                catch (Exception e) {
                    if (this.multiByteLength != 1) continue;
                    this.addEncodingMapping(encoding);
                }
            }
            if (this.encodings.isEmpty()) {
                this.addEncodingMapping(this.multiByteLength > 1 ? UTF8 : CP1252);
            }
        }

        private void addEncodingMapping(String encoding) {
            String encodingValue = encoding.toUpperCase(Locale.ENGLISH);
            if (!this.encodings.contains(encodingValue)) {
                this.encodings.add(encodingValue);
            }
        }
    }

    private static class CharacterSetMappings {
        List<CharacterSetMapping> characterSets;
        List<CollationMapping> collations;

        @JsonCreator
        CharacterSetMappings(@JsonProperty(value="character_sets") List<CharacterSetMapping> characterSets, @JsonProperty(value="collation_mappings") List<CollationMapping> collationMappings) {
            this.characterSets = characterSets;
            this.collations = collationMappings;
        }
    }

    private static class CollationMapping {
        int index;
        List<String> collations;
        int priority;
        String charSetName;

        @JsonCreator
        CollationMapping(@JsonProperty(value="index") int index, @JsonProperty(value="collations") List<String> collations, @JsonProperty(value="priority") int priority, @JsonProperty(value="charset") String charSetName) {
            this.index = index;
            this.collations = collations;
            this.priority = priority;
            this.charSetName = charSetName;
        }
    }
}

