/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr.listener;

import io.debezium.connector.mariadb.antlr.MariaDbAntlrDdlParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParserBaseListener;
import io.debezium.relational.TableId;
import org.antlr.v4.runtime.misc.Interval;

public class DropTableParserListener
extends MariaDBParserBaseListener {
    private final MariaDbAntlrDdlParser parser;

    public DropTableParserListener(MariaDbAntlrDdlParser parser) {
        this.parser = parser;
    }

    public void enterDropTable(MariaDBParser.DropTableContext ctx) {
        Interval interval = new Interval(ctx.start.getStartIndex(), ctx.tables().start.getStartIndex() - 1);
        String prefix = ctx.start.getInputStream().getText(interval);
        ctx.tables().tableName().forEach(tableNameContext -> {
            TableId tableId = this.parser.parseQualifiedTableId(tableNameContext.fullId());
            this.parser.databaseTables().removeTable(tableId);
            this.parser.signalDropTable(tableId, prefix + tableId.toQuotedString('`') + (String)(ctx.dropType != null ? " " + ctx.dropType.getText() : ""));
        });
        super.enterDropTable(ctx);
    }
}

