/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogEventMetadataProvider;
import io.debezium.connector.binlog.BinlogSourceTask;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.jdbc.BinlogFieldReader;
import io.debezium.connector.binlog.jdbc.BinlogValueConverters;
import io.debezium.connector.binlog.jdbc.ConnectionConfiguration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mariadb.MariaDbChangeEventSourceFactory;
import io.debezium.connector.mariadb.MariaDbConnector;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbDatabaseSchema;
import io.debezium.connector.mariadb.MariaDbErrorHandler;
import io.debezium.connector.mariadb.MariaDbOffsetContext;
import io.debezium.connector.mariadb.MariaDbPartition;
import io.debezium.connector.mariadb.MariaDbReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.mariadb.MariaDbTaskContext;
import io.debezium.connector.mariadb.Module;
import io.debezium.connector.mariadb.jdbc.MariaDbConnection;
import io.debezium.connector.mariadb.jdbc.MariaDbConnectionConfiguration;
import io.debezium.connector.mariadb.jdbc.MariaDbFieldReader;
import io.debezium.connector.mariadb.jdbc.MariaDbValueConverters;
import io.debezium.connector.mariadb.metrics.MariaDbChangeEventSourceMetricsFactory;
import io.debezium.connector.mariadb.metrics.MariaDbStreamingChangeEventSourceMetrics;
import io.debezium.document.DocumentReader;
import io.debezium.heartbeat.HeartbeatErrorHandler;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.snapshot.Snapshotter;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbConnectorTask
extends BinlogSourceTask<MariaDbPartition, MariaDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbConnectorTask.class);
    private static final String CONTEXT_NAME = "mariadb-connector-task";
    private volatile MariaDbTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile BinlogConnectorConnection connection;
    private volatile BinlogConnectorConnection beanRegistryJdbcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile MariaDbDatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return MariaDbConnectorConfig.ALL_FIELDS;
    }

    protected ChangeEventSourceCoordinator<MariaDbPartition, MariaDbOffsetContext> start(Configuration configuration) {
        Clock clock = Clock.system();
        MariaDbConnectorConfig connectorConfig = new MariaDbConnectorConfig(configuration);
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(BinlogConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        MariaDbValueConverters valueConverters = this.getValueConverters(connectorConfig);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)configuration.edit().withDefault("database.responseBuffering", "adaptive").withDefault("database.fetchSize", 10000)).withDefault("database.useCursorFetch", connectorConfig.useCursorFetch())).build();
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> {
            MariaDbConnectionConfiguration connectionConfig = new MariaDbConnectionConfiguration(config);
            return new MariaDbConnection((ConnectionConfiguration)connectionConfig, new MariaDbFieldReader(connectorConfig));
        });
        this.connection = (BinlogConnectorConnection)connectionFactory.mainConnection();
        Offsets previousOffsets = this.getPreviousOffsets(new MariaDbPartition.Provider(connectorConfig, config), (OffsetContext.Loader)new MariaDbOffsetContext.Loader(connectorConfig));
        boolean tableIdCaseInsensitive = this.connection.isTableIdCaseSensitive();
        this.schema = new MariaDbDatabaseSchema(connectorConfig, valueConverters, (TopicNamingStrategy<TableId>)topicNamingStrategy, schemaNameAdjuster, tableIdCaseInsensitive);
        this.beanRegistryJdbcConnection = (BinlogConnectorConnection)connectionFactory.newConnection();
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)this.beanRegistryJdbcConnection);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        Snapshotter snapshotter = snapshotterService.getSnapshotter();
        this.validateBinlogConfiguration(snapshotter, this.connection);
        if (this.validateSnapshotFeasibility(snapshotter, (OffsetContext)((MariaDbOffsetContext)previousOffsets.getTheOnlyOffset()), this.connection)) {
            previousOffsets.resetOffset((Partition)((MariaDbPartition)previousOffsets.getTheOnlyPartition()));
        }
        LOGGER.info("Closing JDBC connection before starting schema recovery.");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        MariaDbOffsetContext previousOffset = (MariaDbOffsetContext)previousOffsets.getTheOnlyOffset();
        this.validateAndLoadSchemaHistory((CommonConnectorConfig)connectorConfig, (arg_0, arg_1, arg_2) -> ((BinlogConnectorConnection)this.connection).validateLogPosition(arg_0, arg_1, arg_2), previousOffsets, (DatabaseSchema)this.schema, snapshotter);
        LOGGER.info("Reconnecting after finishing schema recovery");
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        if (previousOffset == null) {
            LOGGER.info("No previous offset found");
        } else {
            LOGGER.info("Found previous offset {}", (Object)previousOffset);
        }
        this.taskContext = new MariaDbTaskContext(connectorConfig, this.schema);
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).buffering().build();
        this.errorHandler = new MariaDbErrorHandler(connectorConfig, this.queue, this.errorHandler);
        BinlogEventMetadataProvider metadataProvider = new BinlogEventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(MariaDbConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
        this.resetOffset(connectorConfig, (OffsetContext)previousOffset, signalProcessor);
        Configuration heartbeatConfig = config;
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, null, (EventMetadataProvider)metadataProvider, connectorConfig.createHeartbeat(topicNamingStrategy, schemaNameAdjuster, () -> new MariaDbConnection((ConnectionConfiguration)new MariaDbConnectionConfiguration(heartbeatConfig), this.getFieldReader(connectorConfig)), (HeartbeatErrorHandler)new BinlogSourceTask.BinlogHeartbeatErrorHandler()), schemaNameAdjuster, signalProcessor);
        MariaDbStreamingChangeEventSourceMetrics streamingMetrics = new MariaDbStreamingChangeEventSourceMetrics(this.taskContext, (ChangeEventQueueMetrics)this.queue, (EventMetadataProvider)metadataProvider);
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, MariaDbConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new MariaDbChangeEventSourceFactory(connectorConfig, (MainConnectionProvidingConnectionFactory<BinlogConnectorConnection>)connectionFactory, this.errorHandler, (EventDispatcher<MariaDbPartition, TableId>)dispatcher, clock, this.schema, this.taskContext, streamingMetrics, this.queue, snapshotterService), (ChangeEventSourceMetricsFactory)new MariaDbChangeEventSourceMetricsFactory(streamingMetrics), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    protected void doStop() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing the JDBC connection.", (Throwable)e);
        }
        try {
            if (this.beanRegistryJdbcConnection != null) {
                this.beanRegistryJdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing the Bean Registry JDBC connection.", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected Long getReadOnlyIncrementalSnapshotSignalOffset(MariaDbOffsetContext previousOffset) {
        return ((MariaDbReadOnlyIncrementalSnapshotContext)previousOffset.getIncrementalSnapshotContext()).getSignalOffset();
    }

    private MariaDbValueConverters getValueConverters(MariaDbConnectorConfig connectorConfig) {
        return new MariaDbValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), connectorConfig.getBigIntUnsignedHandlingMode().asBigIntUnsignedMode(), connectorConfig.binaryHandlingMode(), connectorConfig.isTimeAdjustedEnabled() ? BinlogValueConverters::adjustTemporal : x -> x, connectorConfig.getEventConvertingFailureHandlingMode(), connectorConfig.getServiceRegistry());
    }

    private BinlogFieldReader getFieldReader(MariaDbConnectorConfig connectorConfig) {
        return new MariaDbFieldReader(connectorConfig);
    }
}

