/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.util;

import io.debezium.config.Field;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.util.Map;

public class MariaDbTestConnection
extends BinlogTestConnection {
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mariadb://${hostname}:${port}/${dbname}", (Field[])new Field[0]);

    public MariaDbTestConnection(JdbcConfiguration config) {
        super(config, FACTORY);
    }

    public boolean isGtidEnabled() {
        return true;
    }

    public boolean isMariaDb() {
        return true;
    }

    public boolean isMySQL5() {
        return false;
    }

    public boolean isPercona() {
        return false;
    }

    public String currentDateTimeDefaultOptional(String isoString) {
        return null;
    }

    public void setBinlogCompressionOff() throws SQLException {
        this.execute(new String[]{"set global log_bin_compress=OFF;"});
    }

    public void setBinlogCompressionOn() throws SQLException {
        this.execute(new String[]{"set global log_bin_compress=ON;"});
    }

    public void setBinlogRowQueryEventsOff() throws SQLException {
        this.execute(new String[]{"set binlog_annotate_row_events=OFF;"});
    }

    public void setBinlogRowQueryEventsOn() throws SQLException {
        this.execute(new String[]{"set binlog_annotate_row_events=ON;"});
    }

    public boolean isCurrentDateTimeDefaultGenerated() {
        return false;
    }

    public static MariaDbTestConnection forTestDatabase(String databaseName) {
        return new MariaDbTestConnection((JdbcConfiguration)MariaDbTestConnection.getDefaultJdbcConfig((String)databaseName).build());
    }

    public static MariaDbTestConnection forTestDatabase(String databaseName, int queryTimeout) {
        return new MariaDbTestConnection((JdbcConfiguration)MariaDbTestConnection.getDefaultJdbcConfig((String)databaseName).withQueryTimeoutMs(queryTimeout).build());
    }

    public static MariaDbTestConnection forTestDatabase(String databaseName, Map<String, Object> urlProperties) {
        JdbcConfiguration.Builder builder = MariaDbTestConnection.getDefaultJdbcConfig((String)databaseName);
        urlProperties.forEach((arg_0, arg_1) -> ((JdbcConfiguration.Builder)builder).with(arg_0, arg_1));
        return new MariaDbTestConnection((JdbcConfiguration)builder.build());
    }

    public static MariaDbTestConnection forTestReplicaDatabase(String databaseName) {
        return new MariaDbTestConnection((JdbcConfiguration)MariaDbTestConnection.getReplicaJdbcConfig((String)databaseName).build());
    }
}

