/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.rest;

import io.debezium.connector.mariadb.MariaDbConnector;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.Module;
import io.debezium.connector.mariadb.rest.DebeziumMariaDbConnectRestExtension;
import io.debezium.storage.kafka.history.KafkaSchemaHistory;
import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class DebeziumMariaDbConnectorResourceIT {
    @BeforeClass
    public static void checkCondition() {
        Assume.assumeThat((String)"Skipping DebeziumMariaDbConnectorResourceIT tests when assembly profile is not active!", (Object)System.getProperty("isAssemblyProfileActive", "false"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Before
    public void start() {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumMariaDbConnectRestExtension.class.getName());
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.MARIADB);
    }

    @After
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
    }

    @Test
    public void testValidConnection() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testInvalidHostnameConnection() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]).with(MariaDbConnectorConfig.HOSTNAME.name(), "zzzzzzzzzz");
        Locale.setDefault(new Locale("en", "US"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)MariaDbConnectorConfig.HOSTNAME.name()), new Object[0])).body("message", CoreMatchers.startsWith((String)"Unable to connect: Socket fail to connect"), new Object[0]);
    }

    @Test
    public void testInvalidConnection() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body("{\"connector.class\": \"" + MariaDbConnector.class.getName() + "\"}").put("/debezium/mariadb/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)4), new Object[0])).body("validationResults", CoreMatchers.hasItems((Object[])new Map[]{Map.of("property", MariaDbConnectorConfig.USER.name(), "message", "The 'database.user' value is invalid: A value is required"), Map.of("property", MariaDbConnectorConfig.TOPIC_PREFIX.name(), "message", "The 'topic.prefix' value is invalid: A value is required"), Map.of("property", MariaDbConnectorConfig.SERVER_ID.name(), "message", "The 'database.server.id' value is invalid: A value is required"), Map.of("property", MariaDbConnectorConfig.HOSTNAME.name(), "message", "The 'database.hostname' value is invalid: A value is required")}), new Object[0]);
    }

    @Test
    public void testFiltersWithEmptyFilters() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)6), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", "inventory", "name", "geom", "identifier", "inventory.geom"), Map.of("namespace", "inventory", "name", "products_on_hand", "identifier", "inventory.products_on_hand"), Map.of("namespace", "inventory", "name", "customers", "identifier", "inventory.customers"), Map.of("namespace", "inventory", "name", "addresses", "identifier", "inventory.addresses"), Map.of("namespace", "inventory", "name", "orders", "identifier", "inventory.orders"), Map.of("namespace", "inventory", "name", "products", "identifier", "inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidTableIncludeList() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]).with("table.include.list", "inventory\\.product.*");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)2), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", "inventory", "name", "products_on_hand", "identifier", "inventory.products_on_hand"), Map.of("namespace", "inventory", "name", "products", "identifier", "inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidDatabaseIncludeList() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]).with("database.include.list", "inventory");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)6), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", "inventory", "name", "geom", "identifier", "inventory.geom"), Map.of("namespace", "inventory", "name", "products_on_hand", "identifier", "inventory.products_on_hand"), Map.of("namespace", "inventory", "name", "customers", "identifier", "inventory.customers"), Map.of("namespace", "inventory", "name", "addresses", "identifier", "inventory.addresses"), Map.of("namespace", "inventory", "name", "orders", "identifier", "inventory.orders"), Map.of("namespace", "inventory", "name", "products", "identifier", "inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidDatabaseIncludeListPattern() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]).with("database.include.list", "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"database.include.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'database.include.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidDatabaseExcludeListPattern() {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]).with("database.exclude.list", "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mariadb/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"database.exclude.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'database.exclude.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testMetricsEndpoint() throws InterruptedException {
        ConnectorConfiguration config = DebeziumMariaDbConnectorResourceIT.getMariaDbConnectorConfiguration(1, new String[0]);
        String connectorName = "my-mariadb-connector";
        RestExtensionTestInfrastructure.getDebeziumContainer().registerConnector(connectorName, config);
        RestExtensionTestInfrastructure.getDebeziumContainer().ensureConnectorState(connectorName, Connector.State.RUNNING);
        RestExtensionTestInfrastructure.waitForConnectorTaskStatus((String)connectorName, (int)0, (Connector.State)Connector.State.RUNNING);
        RestExtensionTestInfrastructure.getDebeziumContainer().waitForStreamingRunning("mariadb", config.asProperties().getProperty("topic.prefix"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).get("/debezium/mariadb/connectors/{connector-name}/metrics", new Object[]{connectorName})).then()).log().all()).statusCode(200)).body("name", CoreMatchers.equalTo((Object)connectorName), new Object[0])).body("connector.metrics.Connected", CoreMatchers.equalTo((Object)"true"), new Object[0])).body("tasks[0].id", CoreMatchers.equalTo((Object)0), new Object[0])).body("tasks[0].namespaces[0].metrics.MilliSecondsSinceLastEvent", CoreMatchers.equalTo((Object)"0"), new Object[0])).body("tasks[0].namespaces[0].metrics.TotalNumberOfEventsSeen", CoreMatchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    public static ConnectorConfiguration getMariaDbConnectorConfiguration(int id, String ... options) {
        ConnectorConfiguration config = ConnectorConfiguration.forJdbcContainer((JdbcDatabaseContainer)RestExtensionTestInfrastructure.getMariaDbContainer()).with(MariaDbConnectorConfig.USER.name(), "debezium").with(MariaDbConnectorConfig.PASSWORD.name(), "dbz").with(MariaDbConnectorConfig.SNAPSHOT_MODE.name(), "never").with(MariaDbConnectorConfig.TOPIC_PREFIX.name(), "dbserver" + id).with(KafkaSchemaHistory.BOOTSTRAP_SERVERS.name(), "kafka-dbz-ui:9092").with(KafkaSchemaHistory.TOPIC.name(), "dbhistory.inventory").with(MariaDbConnectorConfig.SERVER_ID.name(), Long.valueOf(5555 + id - 1)).with(MariaDbConnectorConfig.SSL_MODE.name(), "disabled");
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        return config;
    }
}

