/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.rest;

import io.debezium.connector.mariadb.MariaDbConnector;
import io.debezium.connector.mariadb.Module;
import io.debezium.connector.mariadb.rest.DebeziumMariaDbConnectRestExtension;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DebeziumMariaDbConnectorResourceNoDatabaseIT {
    @BeforeClass
    public static void checkCondition() {
        Assume.assumeThat((String)"Skipping DebeziumMariaDbConnectorResourceIT tests when assembly profile is not active!", (Object)System.getProperty("isAssemblyProfileActive", "false"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Before
    public void start() {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumMariaDbConnectRestExtension.class.getName());
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
    }

    @After
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
    }

    @Test
    public void testVersionEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/mariadb/version", new Object[0])).then()).log().all()).statusCode(200)).body(CoreMatchers.is((Object)Module.version()), new Matcher[0]);
    }

    @Test
    public void testSchemaEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/mariadb/schema", new Object[0])).then()).log().all()).statusCode(200)).body("components.schemas.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("components.schemas.values()[0]")).body("title", CoreMatchers.is((Object)"Debezium MariaDB Connector"), new Object[0])).body("properties.isEmpty()", CoreMatchers.is((Object)false), new Object[0])).body("x-connector-id", CoreMatchers.is((Object)"mariadb"), new Object[0])).body("x-version", CoreMatchers.is((Object)Module.version()), new Object[0])).body("x-className", CoreMatchers.is((Object)MariaDbConnector.class.getName()), new Object[0])).body("properties", Matchers.hasKey((Object)"topic.prefix"), new Object[0])).body("properties", Matchers.hasKey((Object)"database.server.id"), new Object[0])).body("properties", Matchers.hasKey((Object)"snapshot.mode"), new Object[0]);
    }
}

