/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.connector.binlog.BinlogConnectionIT;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.connector.mariadb.MariaDbCommon;
import io.debezium.connector.mariadb.MariaDbConnector;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;

public class ConnectionIT
extends BinlogConnectionIT<MariaDbConnector>
implements MariaDbCommon {
    @Test
    public void whenQueryTakesMoreThenConfiguredQueryTimeoutAnExceptionMustBeThrown() throws SQLException {
        UniqueDatabase DATABASE2 = TestHelper.getUniqueDatabase((String)"readbinlog", (String)"readbinlog_test");
        DATABASE2.createAndInitialize();
        try (BinlogTestConnection conn = this.getTestDatabaseConnection(DATABASE2.getDatabaseName(), 1000);){
            conn.connect();
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> conn.execute(new String[]{"SELECT SLEEP(10)"})).isInstanceOf(SQLTimeoutException.class)).hasMessageContaining("Query execution was interrupted (max_statement_time exceeded)");
        }
    }
}

