/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.MariadbGtidSet;
import com.github.shyiko.mysql.binlog.event.AnnotateRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.MariadbGtidEventData;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogStreamingChangeEventSource;
import io.debezium.connector.binlog.BinlogTaskContext;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.metrics.BinlogStreamingChangeEventSourceMetrics;
import io.debezium.connector.mariadb.MariaDbConnector;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbOffsetContext;
import io.debezium.connector.mariadb.MariaDbPartition;
import io.debezium.connector.mariadb.MariaDbTaskContext;
import io.debezium.connector.mariadb.metrics.MariaDbStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.relational.TableId;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbStreamingChangeEventSource
extends BinlogStreamingChangeEventSource<MariaDbPartition, MariaDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbStreamingChangeEventSource.class);
    private final MariaDbConnectorConfig connectorConfig;
    private final TableId signalDataCollectionId;
    private MariadbGtidSet gtidSet;

    public MariaDbStreamingChangeEventSource(MariaDbConnectorConfig connectorConfig, BinlogConnectorConnection connection, EventDispatcher<MariaDbPartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, MariaDbTaskContext taskContext, MariaDbStreamingChangeEventSourceMetrics metrics, SnapshotterService snapshotterService) {
        super((BinlogConnectorConfig)connectorConfig, connection, dispatcher, errorHandler, clock, (BinlogTaskContext)taskContext, (BinlogDatabaseSchema)taskContext.getSchema(), (BinlogStreamingChangeEventSourceMetrics)metrics, snapshotterService);
        this.connectorConfig = connectorConfig;
        this.signalDataCollectionId = MariaDbStreamingChangeEventSource.getSignalDataCollectionId(connectorConfig);
    }

    public void init(MariaDbOffsetContext offsetContext) {
        this.setEffectiveOffsetContext(offsetContext != null ? offsetContext : MariaDbOffsetContext.initial(this.connectorConfig));
    }

    protected Class<? extends SourceConnector> getConnectorClass() {
        return MariaDbConnector.class;
    }

    protected BinaryLogClient createBinaryLogClient(BinlogTaskContext<?> taskContext, BinlogConnectorConfig connectorConfig, Map<String, Thread> clientThreads, BinlogConnectorConnection connection) {
        BinaryLogClient client = super.createBinaryLogClient(taskContext, connectorConfig, clientThreads, connection);
        if (connectorConfig.isSqlQueryIncluded()) {
            client.setUseSendAnnotateRowsEvent(true);
        }
        return client;
    }

    protected void configureReplicaCompatibility(BinaryLogClient client) {
        client.setMariaDbSlaveCapability(4);
    }

    protected void setEventTimestamp(Event event, long eventTs) {
        this.eventTimestamp = Instant.ofEpochMilli(eventTs);
    }

    protected void handleGtidEvent(MariaDbPartition partition, MariaDbOffsetContext offsetContext, Event event, Predicate<String> gtidDmlSourceFilter) throws InterruptedException {
        String uuid;
        LOGGER.debug("MariaDB GTID transaction: {}", (Object)event);
        MariadbGtidEventData gtidEvent = (MariadbGtidEventData)this.unwrapData(event);
        String gtid = String.format("%d-%d-%d", gtidEvent.getDomainId(), event.getHeader().getServerId(), gtidEvent.getSequence());
        this.gtidSet.add(gtid);
        offsetContext.startGtid(gtid, this.gtidSet.toString());
        this.setIgnoreDmlEventByGtidSource(false);
        if (gtidDmlSourceFilter != null && gtid != null && !gtidDmlSourceFilter.test(uuid = gtidEvent.getDomainId() + "-" + gtidEvent.getServerId())) {
            this.setIgnoreDmlEventByGtidSource(true);
        }
        this.setGtidChanged(gtid);
        this.handleTransactionBegin(partition, offsetContext, event, null);
    }

    protected void handleRecordingQuery(MariaDbOffsetContext offsetContext, Event event) {
        EventData eventData = this.unwrapData(event);
        if (eventData instanceof AnnotateRowsEventData) {
            String query = ((AnnotateRowsEventData)eventData).getRowsQuery();
            if (this.signalDataCollectionId != null && query.toLowerCase().contains(this.signalDataCollectionId.toQuotedString('`').toLowerCase())) {
                return;
            }
            offsetContext.setQuery(query);
        }
    }

    protected EventType getIncludeQueryEventType() {
        return EventType.ANNOTATE_ROWS;
    }

    protected EventType getGtidEventType() {
        return EventType.MARIADB_GTID;
    }

    protected void initializeGtidSet(String value) {
        this.gtidSet = new MariadbGtidSet(value);
    }

    private static TableId getSignalDataCollectionId(MariaDbConnectorConfig connectorConfig) {
        if (!Strings.isNullOrBlank((String)connectorConfig.getSignalingDataCollectionId())) {
            return TableId.parse((String)connectorConfig.getSignalingDataCollectionId());
        }
        return null;
    }
}

