/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr.listener;

import io.debezium.connector.mariadb.antlr.MariaDbAntlrDdlParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewSelectedColumnsParserListener
extends MariaDBParserBaseListener {
    private final MariaDbAntlrDdlParser parser;
    private final TableEditor tableEditor;
    private TableEditor selectTableEditor;
    private Map<TableId, Table> tableByAlias = new HashMap<TableId, Table>();

    public ViewSelectedColumnsParserListener(TableEditor tableEditor, MariaDbAntlrDdlParser parser) {
        this.tableEditor = tableEditor;
        this.parser = parser;
    }

    public List<Column> getSelectedColumns() {
        return this.selectTableEditor.columns();
    }

    public void exitQuerySpecification(MariaDBParser.QuerySpecificationContext ctx) {
        if (ctx.fromClause() != null) {
            this.parseQuerySpecification(ctx.selectElements());
        }
        super.exitQuerySpecification(ctx);
    }

    public void exitQuerySpecificationNointo(MariaDBParser.QuerySpecificationNointoContext ctx) {
        if (ctx.fromClause() != null) {
            this.parseQuerySpecification(ctx.selectElements());
        }
        super.exitQuerySpecificationNointo(ctx);
    }

    public void exitAtomTableItem(MariaDBParser.AtomTableItemContext ctx) {
        this.parser.runIfNotNull(() -> this.parseAtomTableItem((MariaDBParser.TableSourceItemContext)ctx, this.tableByAlias), this.tableEditor);
        super.exitAtomTableItem(ctx);
    }

    public void exitSubqueryTableItem(MariaDBParser.SubqueryTableItemContext ctx) {
        this.parser.runIfNotNull(() -> {
            String tableAlias = this.parser.parseName(ctx.uid());
            TableId aliasTableId = this.parser.resolveTableId(this.parser.currentSchema(), tableAlias);
            this.selectTableEditor.tableId(aliasTableId);
            this.tableByAlias.put(aliasTableId, this.selectTableEditor.create());
        }, this.tableEditor);
        super.exitSubqueryTableItem(ctx);
    }

    private void parseQuerySpecification(MariaDBParser.SelectElementsContext selectElementsContext) {
        this.parser.runIfNotNull(() -> {
            this.selectTableEditor = this.parseSelectElements(selectElementsContext);
        }, this.tableEditor);
    }

    private void parseAtomTableItem(MariaDBParser.TableSourceItemContext ctx, Map<TableId, Table> tableByAlias) {
        if (ctx instanceof MariaDBParser.AtomTableItemContext) {
            MariaDBParser.AtomTableItemContext atomTableItemContext = (MariaDBParser.AtomTableItemContext)ctx;
            TableId tableId = this.parser.parseQualifiedTableId(atomTableItemContext.tableName().fullId());
            Table table = tableByAlias.get(tableId);
            if (table == null) {
                table = this.parser.databaseTables().forTable(tableId);
            }
            if (atomTableItemContext.alias != null) {
                TableId aliasTableId = this.parser.resolveTableId(tableId.catalog(), this.parser.parseName(atomTableItemContext.alias));
                tableByAlias.put(aliasTableId, table);
            } else {
                tableByAlias.put(tableId, table);
            }
        }
    }

    private TableEditor parseSelectElements(MariaDBParser.SelectElementsContext ctx) {
        TableEditor table = Table.editor();
        if (ctx.star != null) {
            this.tableByAlias.keySet().forEach(tableId -> table.addColumns((Iterable)this.tableByAlias.get(tableId).columns()));
        } else {
            ctx.selectElement().forEach(selectElementContext -> {
                if (selectElementContext instanceof MariaDBParser.SelectStarElementContext) {
                    TableId tableId = this.parser.parseQualifiedTableId(((MariaDBParser.SelectStarElementContext)selectElementContext).fullId());
                    Table selectedTable = this.tableByAlias.get(tableId);
                    table.addColumns((Iterable)selectedTable.columns());
                } else if (selectElementContext instanceof MariaDBParser.SelectColumnElementContext) {
                    MariaDBParser.SelectColumnElementContext selectColumnElementContext = (MariaDBParser.SelectColumnElementContext)selectElementContext;
                    MariaDBParser.FullColumnNameContext fullColumnNameContext = selectColumnElementContext.fullColumnName();
                    String schemaName = this.parser.currentSchema();
                    String tableName = null;
                    String columnName = this.parser.parseName(fullColumnNameContext.uid());
                    if (fullColumnNameContext.dottedId(0) != null) {
                        tableName = columnName;
                        if (fullColumnNameContext.dottedId(1) != null) {
                            schemaName = tableName;
                            tableName = AbstractDdlParser.withoutQuotes((String)fullColumnNameContext.dottedId(0).getText().substring(1));
                            columnName = AbstractDdlParser.withoutQuotes((String)fullColumnNameContext.dottedId(1).getText().substring(1));
                        } else {
                            columnName = AbstractDdlParser.withoutQuotes((String)fullColumnNameContext.dottedId(0).getText().substring(1));
                        }
                    }
                    String alias = columnName;
                    if (selectColumnElementContext.uid() != null) {
                        alias = this.parser.parseName(selectColumnElementContext.uid());
                    }
                    if (tableName != null) {
                        Table selectedTable = this.tableByAlias.get(this.parser.resolveTableId(schemaName, tableName));
                        this.addColumnFromTable(table, columnName, alias, selectedTable);
                    } else {
                        for (Table selectedTable : this.tableByAlias.values()) {
                            this.addColumnFromTable(table, columnName, alias, selectedTable);
                        }
                    }
                }
            });
        }
        this.tableByAlias.clear();
        return table;
    }

    private MariaDBParser.TableSourceItemContext getTableSourceItemContext(MariaDBParser.TableSourceContext tableSourceContext) {
        if (tableSourceContext instanceof MariaDBParser.TableSourceBaseContext) {
            return ((MariaDBParser.TableSourceBaseContext)tableSourceContext).tableSourceItem();
        }
        if (tableSourceContext instanceof MariaDBParser.TableSourceNestedContext) {
            return ((MariaDBParser.TableSourceNestedContext)tableSourceContext).tableSourceItem();
        }
        return null;
    }

    private void addColumnFromTable(TableEditor table, String columnName, String newColumnName, Table selectedTable) {
        for (Column column : selectedTable.columns()) {
            if (!column.name().equals(columnName)) continue;
            table.addColumn(column.edit().name(newColumnName).create());
            break;
        }
    }
}

