/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr.listener;

import io.debezium.connector.binlog.jdbc.BinlogSystemVariables;
import io.debezium.connector.mariadb.antlr.MariaDbAntlrDdlParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParserBaseListener;
import io.debezium.relational.SystemVariables;
import org.antlr.v4.runtime.ParserRuleContext;

public class SetStatementParserListener
extends MariaDBParserBaseListener {
    private final MariaDbAntlrDdlParser parser;

    public SetStatementParserListener(MariaDbAntlrDdlParser parser) {
        this.parser = parser;
    }

    public void enterSetVariable(MariaDBParser.SetVariableContext ctx) {
        BinlogSystemVariables.BinlogScope scope = null;
        for (int i = 0; i < ctx.variableClause().size(); ++i) {
            String currentDatabaseName;
            String variableName;
            MariaDBParser.VariableClauseContext variableClauseContext = ctx.variableClause(i);
            if (variableClauseContext.uid() == null) {
                if (variableClauseContext.GLOBAL_ID() == null) continue;
                String variableIdentifier = variableClauseContext.GLOBAL_ID().getText();
                if (variableIdentifier.startsWith("@@global.")) {
                    scope = BinlogSystemVariables.BinlogScope.GLOBAL;
                    variableName = variableIdentifier.substring("@@global.".length());
                } else if (variableIdentifier.startsWith("@@session.")) {
                    scope = BinlogSystemVariables.BinlogScope.SESSION;
                    variableName = variableIdentifier.substring("@@session.".length());
                } else if (variableIdentifier.startsWith("@@local.")) {
                    scope = BinlogSystemVariables.BinlogScope.LOCAL;
                    variableName = variableIdentifier.substring("@@local.".length());
                } else {
                    scope = BinlogSystemVariables.BinlogScope.SESSION;
                    variableName = variableIdentifier.substring("@@".length());
                }
            } else {
                if (variableClauseContext.GLOBAL() != null) {
                    scope = BinlogSystemVariables.BinlogScope.GLOBAL;
                } else if (variableClauseContext.SESSION() != null) {
                    scope = BinlogSystemVariables.BinlogScope.SESSION;
                } else if (variableClauseContext.LOCAL() != null) {
                    scope = BinlogSystemVariables.BinlogScope.LOCAL;
                }
                variableName = this.parser.parseName(variableClauseContext.uid());
            }
            String value = this.parser.withoutQuotes((ParserRuleContext)ctx.expression(i));
            this.parser.systemVariables().setVariable((SystemVariables.Scope)scope, variableName, value);
            if ("character_set_database".equalsIgnoreCase(variableName) && (currentDatabaseName = this.parser.currentSchema()) != null) {
                this.parser.charsetNameForDatabase().put(currentDatabaseName, value);
            }
            this.parser.signalSetVariable(variableName, value, i, (ParserRuleContext)ctx);
        }
        super.enterSetVariable(ctx);
    }

    public void enterSetCharset(MariaDBParser.SetCharsetContext ctx) {
        String charsetName = ctx.charsetName() != null ? this.parser.withoutQuotes((ParserRuleContext)ctx.charsetName()) : this.parser.currentDatabaseCharset();
        this.parser.systemVariables().setVariable((SystemVariables.Scope)BinlogSystemVariables.BinlogScope.SESSION, "character_set_client", charsetName);
        this.parser.systemVariables().setVariable((SystemVariables.Scope)BinlogSystemVariables.BinlogScope.SESSION, "character_set_results", charsetName);
        this.parser.systemVariables().setVariable((SystemVariables.Scope)BinlogSystemVariables.BinlogScope.SESSION, "character_set_connection", this.parser.systemVariables().getVariable("character_set_database"));
        super.enterSetCharset(ctx);
    }

    public void enterSetNames(MariaDBParser.SetNamesContext ctx) {
        String charsetName = ctx.charsetName() != null ? this.parser.withoutQuotes((ParserRuleContext)ctx.charsetName()) : this.parser.currentDatabaseCharset();
        this.parser.systemVariables().setVariable((SystemVariables.Scope)BinlogSystemVariables.BinlogScope.SESSION, "character_set_client", charsetName);
        this.parser.systemVariables().setVariable((SystemVariables.Scope)BinlogSystemVariables.BinlogScope.SESSION, "character_set_results", charsetName);
        this.parser.systemVariables().setVariable((SystemVariables.Scope)BinlogSystemVariables.BinlogScope.SESSION, "character_set_connection", charsetName);
        super.enterSetNames(ctx);
    }
}

