/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr.listener;

import io.debezium.connector.mariadb.antlr.MariaDbAntlrDdlParser;
import io.debezium.connector.mariadb.antlr.listener.ViewSelectedColumnsParserListener;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParserBaseListener;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class CreateViewParserListener
extends MariaDBParserBaseListener {
    private final MariaDbAntlrDdlParser parser;
    private final List<ParseTreeListener> listeners;
    private TableEditor tableEditor;
    private ViewSelectedColumnsParserListener selectColumnsListener;

    public CreateViewParserListener(MariaDbAntlrDdlParser parser, List<ParseTreeListener> listeners) {
        this.parser = parser;
        this.listeners = listeners;
    }

    public void enterCreateView(MariaDBParser.CreateViewContext ctx) {
        if (!this.parser.skipViews()) {
            this.tableEditor = this.parser.databaseTables().editOrCreateTable(this.parser.parseQualifiedTableId(ctx.fullId()));
            if (ctx.uidList() != null) {
                ctx.uidList().uid().stream().map(this.parser::parseName).forEach(columnName -> this.tableEditor.addColumn(Column.editor().name(columnName).create()));
            }
            this.selectColumnsListener = new ViewSelectedColumnsParserListener(this.tableEditor, this.parser);
            this.listeners.add((ParseTreeListener)this.selectColumnsListener);
        }
        super.enterCreateView(ctx);
    }

    public void exitCreateView(MariaDBParser.CreateViewContext ctx) {
        this.parser.runIfNotNull(() -> {
            this.tableEditor.addColumns(this.selectColumnsListener.getSelectedColumns());
            if (!this.tableEditor.hasDefaultCharsetName()) {
                this.tableEditor.setDefaultCharsetName(this.parser.charsetForTable(this.tableEditor.tableId()));
            }
            this.parser.databaseTables().overwriteTable(this.tableEditor.create());
            this.listeners.remove((Object)this.selectColumnsListener);
        }, this.tableEditor);
        this.parser.signalCreateView(this.parser.parseQualifiedTableId(ctx.fullId()), (ParserRuleContext)ctx);
        super.exitCreateView(ctx);
    }
}

