/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.antlr.listener;

import io.debezium.connector.mariadb.antlr.MariaDbAntlrDdlParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParser;
import io.debezium.ddl.parser.mariadb.generated.MariaDBParserBaseListener;
import org.antlr.v4.runtime.ParserRuleContext;

public class CreateAndAlterDatabaseParserListener
extends MariaDBParserBaseListener {
    private final MariaDbAntlrDdlParser parser;
    private String databaseName;

    public CreateAndAlterDatabaseParserListener(MariaDbAntlrDdlParser parser) {
        this.parser = parser;
    }

    public void enterCreateDatabase(MariaDBParser.CreateDatabaseContext ctx) {
        this.databaseName = this.parser.parseName(ctx.uid());
        super.enterCreateDatabase(ctx);
    }

    public void exitCreateDatabase(MariaDBParser.CreateDatabaseContext ctx) {
        this.parser.signalCreateDatabase(this.databaseName, (ParserRuleContext)ctx);
        super.exitCreateDatabase(ctx);
    }

    public void enterAlterSimpleDatabase(MariaDBParser.AlterSimpleDatabaseContext ctx) {
        this.databaseName = ctx.uid() == null ? this.parser.currentSchema() : this.parser.parseName(ctx.uid());
        super.enterAlterSimpleDatabase(ctx);
    }

    public void enterCreateDatabaseOption(MariaDBParser.CreateDatabaseOptionContext ctx) {
        String charsetName = this.parser.extractCharset(ctx.charsetName(), ctx.collationName());
        if (ctx.charsetName() != null) {
            if ("DEFAULT".equalsIgnoreCase(charsetName)) {
                charsetName = this.parser.systemVariables().getVariable("character_set_server");
            }
            this.parser.charsetNameForDatabase().put(this.databaseName, charsetName);
        } else if (ctx.charsetName() != null && !this.parser.charsetNameForDatabase().containsKey(charsetName)) {
            this.parser.charsetNameForDatabase().put(this.databaseName, charsetName);
        }
        super.enterCreateDatabaseOption(ctx);
    }
}

