/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.DebeziumException;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogSnapshotChangeEventSource;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.metrics.BinlogSnapshotChangeEventSourceMetrics;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbDatabaseSchema;
import io.debezium.connector.mariadb.MariaDbOffsetContext;
import io.debezium.connector.mariadb.MariaDbPartition;
import io.debezium.connector.mariadb.metrics.MariaDbSnapshotChangeEventSourceMetrics;
import io.debezium.function.BlockingConsumer;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbSnapshotChangeEventSource
extends BinlogSnapshotChangeEventSource<MariaDbPartition, MariaDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbSnapshotChangeEventSource.class);
    private final MariaDbConnectorConfig connectorConfig;

    public MariaDbSnapshotChangeEventSource(MariaDbConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<BinlogConnectorConnection> connectionFactory, MariaDbDatabaseSchema schema, EventDispatcher<MariaDbPartition, TableId> dispatcher, Clock clock, MariaDbSnapshotChangeEventSourceMetrics metrics, BlockingConsumer<Function<SourceRecord, SourceRecord>> lastEventProcessor, Runnable preSnapshotAction, NotificationService<MariaDbPartition, MariaDbOffsetContext> notificationService, SnapshotterService snapshotterService) {
        super((BinlogConnectorConfig)connectorConfig, connectionFactory, (BinlogDatabaseSchema)schema, dispatcher, clock, (BinlogSnapshotChangeEventSourceMetrics)metrics, lastEventProcessor, preSnapshotAction, notificationService, snapshotterService);
        this.connectorConfig = connectorConfig;
    }

    protected MariaDbOffsetContext getInitialOffsetContext(BinlogConnectorConfig connectorConfig) {
        return MariaDbOffsetContext.initial((MariaDbConnectorConfig)connectorConfig);
    }

    protected void setOffsetContextBinlogPositionAndGtidDetailsForSnapshot(MariaDbOffsetContext offsetContext, BinlogConnectorConnection connection, SnapshotterService snapshotterService) throws Exception {
        LOGGER.info("Read binlog position of MariaDB primary server");
        String showMasterStmt = "SHOW MASTER STATUS";
        connection.query("SHOW MASTER STATUS", rs -> {
            if (rs.next()) {
                String binlogFilename = rs.getString(1);
                long binlogPosition = rs.getLong(2);
                offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
                connection.query("SHOW GLOBAL VARIABLES LIKE 'GTID_BINLOG_POS'", rs2 -> {
                    if (rs2.next() && rs2.getMetaData().getColumnCount() > 0) {
                        String gtidSet = rs2.getString(2);
                        offsetContext.setCompletedGtidSet(gtidSet);
                        LOGGER.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
                    } else {
                        LOGGER.info("\t using binlog '{}' at position '{}'", (Object)binlogFilename, (Object)binlogPosition);
                    }
                });
            } else if (!snapshotterService.getSnapshotter().shouldStream()) {
                LOGGER.warn("Failed retrieving binlog position, continuing as streaming CDC wasn't requested");
            } else {
                throw new DebeziumException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured");
            }
        });
    }

    protected MariaDbOffsetContext copyOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<MariaDbPartition, MariaDbOffsetContext> snapshotContext) {
        return new MariaDbOffsetContext.Loader(this.connectorConfig).load(((MariaDbOffsetContext)snapshotContext.offset).getOffset());
    }
}

