/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.binlog.BinlogSourceInfo;
import io.debezium.connector.common.OffsetUtils;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.mariadb.SourceInfo;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;

public class MariaDbOffsetContext
extends BinlogOffsetContext<SourceInfo> {
    public MariaDbOffsetContext(boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext, SourceInfo sourceInfo) {
        super(snapshot, snapshotCompleted, transactionContext, incrementalSnapshotContext, (BinlogSourceInfo)sourceInfo);
    }

    public static MariaDbOffsetContext initial(MariaDbConnectorConfig config) {
        MariaDbOffsetContext offset = new MariaDbOffsetContext(false, false, new TransactionContext(), (IncrementalSnapshotContext<TableId>)(config.isReadOnlyConnection() ? new MariaDbReadOnlyIncrementalSnapshotContext() : new SignalBasedIncrementalSnapshotContext()), new SourceInfo(config));
        offset.setBinlogStartPoint("", 0L);
        return offset;
    }

    public static class Loader
    extends BinlogOffsetContext.Loader<MariaDbOffsetContext> {
        private final MariaDbConnectorConfig connectorConfig;

        public Loader(MariaDbConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public MariaDbOffsetContext load(Map<String, ?> offset) {
            String binlogFilename = (String)offset.get("file");
            if (binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            long binlogPosition = OffsetUtils.longOffsetValue(offset, (String)"pos");
            MariaDbOffsetContext offsetContext = new MariaDbOffsetContext(Loader.isTrue(offset, (String)"snapshot"), Loader.isTrue(offset, (String)"snapshot_completed"), TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)(this.connectorConfig.isReadOnlyConnection() ? MariaDbReadOnlyIncrementalSnapshotContext.load(offset) : SignalBasedIncrementalSnapshotContext.load(offset)), new SourceInfo(this.connectorConfig));
            offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
            offsetContext.setInitialSkips(OffsetUtils.longOffsetValue(offset, (String)"event"), (int)OffsetUtils.longOffsetValue(offset, (String)"row"));
            offsetContext.setCompletedGtidSet((String)offset.get("gtids"));
            return offsetContext;
        }
    }
}

