/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.binlog.BinlogConnectorIT;
import io.debezium.connector.mariadb.MariaDbCommon;
import io.debezium.connector.mariadb.MariaDbConnector;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.MariaDbOffsetContext;
import io.debezium.connector.mariadb.MariaDbPartition;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.assertj.core.api.Assertions;

public class MariaDbConnectorIT
extends BinlogConnectorIT<MariaDbConnector, MariaDbPartition, MariaDbOffsetContext>
implements MariaDbCommon {
    protected Config validateConfiguration(Configuration configuration) {
        return new MariaDbConnector().validate(configuration.asMap());
    }

    protected void assertInvalidConfiguration(Config result) {
        super.assertInvalidConfiguration(result);
        this.assertNoConfigurationErrors(result, new Field[]{MariaDbConnectorConfig.SNAPSHOT_LOCKING_MODE});
    }

    protected void assertValidConfiguration(Config result) {
        super.assertValidConfiguration(result);
        this.validateConfigField(result, MariaDbConnectorConfig.SNAPSHOT_LOCKING_MODE, MariaDbConnectorConfig.SnapshotLockingMode.MINIMAL);
    }

    protected Field getSnapshotLockingModeField() {
        return MariaDbConnectorConfig.SNAPSHOT_LOCKING_MODE;
    }

    protected String getSnapshotLockingModeNone() {
        return MariaDbConnectorConfig.SnapshotLockingMode.NONE.getValue();
    }

    protected void assertSnapshotLockingModeIsNone(Configuration config) {
        Assertions.assertThat((Comparable)((MariaDbConnectorConfig.SnapshotLockingMode)new MariaDbConnectorConfig(config).getSnapshotLockingMode().get())).isEqualTo((Object)MariaDbConnectorConfig.SnapshotLockingMode.NONE);
    }

    protected MariaDbPartition createPartition(String serverName, String databaseName) {
        return new MariaDbPartition(serverName, databaseName);
    }

    protected MariaDbOffsetContext loadOffsets(Configuration configuration, Map<String, ?> offsets) {
        return new MariaDbOffsetContext.Loader(new MariaDbConnectorConfig(configuration)).load(offsets);
    }

    protected void assertBinlogPosition(long offsetPosition, long beforeInsertsPosition) {
        Assertions.assertThat((long)offsetPosition).isGreaterThanOrEqualTo(beforeInsertsPosition);
    }

    protected String getExpectedQuery(String statement) {
        return "SET STATEMENT max_statement_time=600 FOR " + statement;
    }
}

