/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mariadb.jdbc;

import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.jdbc.BinlogFieldReader;
import io.debezium.connector.mariadb.MariaDbConnectorConfig;
import io.debezium.connector.mariadb.charset.CharsetMappingResolver;
import io.debezium.connector.mariadb.jdbc.MariaDbValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Objects;

public class MariaDbFieldReader
extends BinlogFieldReader {
    public MariaDbFieldReader(MariaDbConnectorConfig connectorConfig) {
        super((BinlogConnectorConfig)connectorConfig);
    }

    protected String getCharacterSet(Column column) throws UnsupportedEncodingException {
        return CharsetMappingResolver.getJavaEncodingForMariaDbCharSet(column.charsetName());
    }

    protected Object readTimeField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        String value = rs.getString(columnIndex);
        return Objects.isNull(value) ? null : MariaDbValueConverters.stringToDuration((String)value);
    }

    protected Object readDateField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        String value = rs.getString(columnIndex);
        return Objects.isNull(value) ? null : MariaDbValueConverters.stringToLocalDate((String)value, (Column)column, (Table)table);
    }

    protected Object readTimestampField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        String value = rs.getString(columnIndex);
        if (Objects.isNull(value)) {
            return null;
        }
        return MariaDbValueConverters.containsZeroValuesInDatePart((String)value, (Column)column, (Table)table) ? null : rs.getTimestamp(columnIndex, Calendar.getInstance());
    }
}

