/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.mysql;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.jupiter.MySqlSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.testcontainers.utility.ThrowingFunction;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-mysql")})
@ExtendWith(value={MySqlSinkDatabaseContextProvider.class})
public class JdbcSinkColumnTypeMappingIT
extends AbstractJdbcSinkTest {
    public JdbcSinkColumnTypeMappingIT(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6967"})
    public void testShouldCoerceNioByteBufferTypeToByteArrayColumnType(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        ByteBuffer buffer = ByteBuffer.allocate(3);
        buffer.put((byte)1);
        buffer.put((byte)2);
        buffer.put((byte)3);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", Schema.OPTIONAL_BYTES_SCHEMA, buffer);
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data binary(3), primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data binary(3), primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((byte[])rs.getBytes(2)).isEqualTo(new byte[]{1, 2, 3});
            return null;
        }));
    }
}

