/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.postgresql.util.PGobject;

public abstract class AbstractPostgreSQLJsonPGObjectType
extends JsonJdbcType {
    private final boolean jsonb;

    protected AbstractPostgreSQLJsonPGObjectType(EmbeddableMappingType embeddableMappingType, boolean jsonb) {
        super(embeddableMappingType);
        this.jsonb = jsonb;
    }

    @Override
    public int getJdbcTypeCode() {
        return 1111;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String stringValue = ((AbstractPostgreSQLJsonPGObjectType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                PGobject holder = new PGobject();
                holder.setType(AbstractPostgreSQLJsonPGObjectType.this.jsonb ? "jsonb" : "json");
                holder.setValue(stringValue);
                st.setObject(index, holder);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String stringValue = ((AbstractPostgreSQLJsonPGObjectType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                PGobject holder = new PGobject();
                holder.setType(AbstractPostgreSQLJsonPGObjectType.this.jsonb ? "jsonb" : "json");
                holder.setValue(stringValue);
                st.setObject(name, (Object)holder);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(name), options);
            }

            private X getObject(Object object, WrapperOptions options) throws SQLException {
                if (object == null) {
                    return null;
                }
                return ((AbstractPostgreSQLJsonPGObjectType)this.getJdbcType()).fromString(object.toString(), this.getJavaType(), options);
            }
        };
    }
}

