/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.mysql.JsonType;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.connect.AbstractConnectMapType;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

class MapToJsonType
extends AbstractConnectMapType {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final MapToJsonType INSTANCE = new MapToJsonType();

    MapToJsonType() {
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return JsonType.INSTANCE.getQueryBinding(column, schema, value);
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return JsonType.INSTANCE.getTypeName(dialect, schema, key);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value instanceof Map) {
            try {
                value = OBJECT_MAPPER.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new ConnectException("Failed to deserialize MAP data to JSON", (Throwable)e);
            }
        }
        return JsonType.INSTANCE.bind(index, schema, value);
    }
}

