/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.type.debezium.ZonedTimeType;
import io.debezium.time.ZonedTime;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

class TimeWithTimezoneType
extends ZonedTimeType {
    public static final TimeWithTimezoneType INSTANCE = new TimeWithTimezoneType();

    TimeWithTimezoneType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTime"};
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof String) {
            ZonedDateTime zdt = OffsetTime.parse((String)value, ZonedTime.FORMATTER).atDate(LocalDate.now()).toZonedDateTime();
            if (this.getDialect().isTimeZoneSet()) {
                if (this.getDialect().shouldBindTimeWithTimeZoneAsDatabaseTimeZone()) {
                    return List.of(new ValueBindDescriptor(index, zdt.withZoneSameInstant(this.getDatabaseTimeZone().toZoneId())));
                }
                return List.of(new ValueBindDescriptor(index, zdt.toOffsetDateTime().toOffsetTime()));
            }
            return List.of(new ValueBindDescriptor(index, zdt));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

