/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.jupiter.PostgresSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.sink.SinkRecord;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.testcontainers.utility.ThrowingFunction;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-postgresql")})
@ExtendWith(value={PostgresSinkDatabaseContextProvider.class})
public class JdbcSinkColumnTypeMappingIT
extends AbstractJdbcSinkTest {
    public JdbcSinkColumnTypeMappingIT(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6589"})
    public void testShouldCoerceStringTypeToUuidColumnType(SinkRecordFactory factory) throws Exception {
        this.shouldCoerceStringTypeToColumnType(factory, "uuid", "9bc6a215-84b5-4865-a058-9156427c887a", "f54c2926-076a-4db0-846f-14cad99a8307");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6589"})
    public void testShouldCoerceStringTypeToJsonColumnType(SinkRecordFactory factory) throws Exception {
        this.shouldCoerceStringTypeToColumnType(factory, "json", "{\"id\": 12345}", "{\"id\": 67890}");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6589"})
    public void testShouldCoerceStringTypeToJsonbColumnType(SinkRecordFactory factory) throws Exception {
        this.shouldCoerceStringTypeToColumnType(factory, "jsonb", "{\"id\": 12345}", "{\"id\": 67890}");
    }

    private void shouldCoerceStringTypeToColumnType(SinkRecordFactory factory, String columnType, String insertValue, String updateValue) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        properties.put("delete.enabled", "false");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", Schema.OPTIONAL_STRING_SCHEMA, insertValue);
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data %s null, primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data %s null, primary key(id))", destinationTable, columnType));
        this.consume(createRecord);
        SinkRecord updateRecord = factory.updateRecordWithSchemaValue(topicName, (byte)1, "data", Schema.OPTIONAL_STRING_SCHEMA, updateValue);
        this.consume(updateRecord);
        this.getSink().assertColumn(destinationTable, "data", columnType);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6967"})
    public void testShouldCoerceNioByteBufferTypeToByteArrayColumnType(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        ByteBuffer buffer = ByteBuffer.allocate(3);
        buffer.put((byte)1);
        buffer.put((byte)2);
        buffer.put((byte)3);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", Schema.OPTIONAL_BYTES_SCHEMA, buffer);
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data bytea, primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data bytea, primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((byte[])rs.getBytes(2)).isEqualTo(new byte[]{1, 2, 3});
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithTextArrayWithASingleValue(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build(), Arrays.asList("a"));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data text[], primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data text[], primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((Object)rs.getArray(2).getArray()).isEqualTo((Object)new String[]{"a"});
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithTextArray(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build(), Arrays.asList("a", "b", "c"));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data text[], primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data text[], primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((Object)rs.getArray(2).getArray()).isEqualTo((Object)new String[]{"a", "b", "c"});
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithTextArrayWithNullValues(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build(), Arrays.asList("a", null, "c", null));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (data text[], id int not null, primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (data text[], id int not null, primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((Object)rs.getArray(1).getArray()).isEqualTo((Object)new String[]{"a", null, "c", null});
            Assertions.assertThat((int)rs.getInt(2)).isEqualTo(1);
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithNullTextArray(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build(), null);
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (data text[], id int not null, primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (data text[], id int not null, primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((Object)rs.getArray(1)).isNull();
            Assertions.assertThat((int)rs.getInt(2)).isEqualTo(1);
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithEmptyArray(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build(), Arrays.asList(new Object[0]));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data text[], primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data text[], primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((Object)rs.getArray(2).getArray()).isEqualTo((Object)new String[0]);
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithCharacterVaryingArray(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build(), Arrays.asList("a", "b", "c"));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data character varying[], primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data character varying[], primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((Object)rs.getArray(2).getArray()).isEqualTo((Object)new String[]{"a", "b", "c"});
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithIntArray(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_INT32_SCHEMA).optional().build(), Arrays.asList(1, 2, 42));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data int[], primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data int[], primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((Object)rs.getArray(2).getArray()).isEqualTo((Object)new Integer[]{1, 2, 42});
            return null;
        }));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-7752"})
    public void testShouldWorkWithBoolArray(SinkRecordFactory factory) throws Exception {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.NONE.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server2", "schema", tableName);
        SinkRecord createRecord = factory.createRecordWithSchemaValue(topicName, (byte)1, "data", SchemaBuilder.array((Schema)Schema.OPTIONAL_BOOLEAN_SCHEMA).optional().build(), Arrays.asList(false, true));
        String destinationTable = this.destinationTableName(createRecord);
        String sql = "CREATE TABLE %s (id int not null, data bool[], primary key(id))";
        this.getSink().execute(String.format("CREATE TABLE %s (id int not null, data bool[], primary key(id))", destinationTable));
        this.consume(createRecord);
        this.getSink().assertRows(destinationTable, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((Object)rs.getArray(2).getArray()).isEqualTo((Object)new Boolean[]{false, true});
            return null;
        }));
    }
}

