/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.e2e;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.e2e.AbstractJdbcSinkPipelineIT;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SqlServerSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.e2e.ForSource;
import io.debezium.connector.jdbc.junit.jupiter.e2e.SkipColumnTypePropagation;
import io.debezium.connector.jdbc.junit.jupiter.e2e.source.Source;
import io.debezium.connector.jdbc.junit.jupiter.e2e.source.SourceType;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.Properties;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.testcontainers.utility.ThrowingFunction;

@Tags(value={@Tag(value="all"), @Tag(value="e2e"), @Tag(value="e2e-sqlserver")})
@ExtendWith(value={SqlServerSinkDatabaseContextProvider.class})
public class JdbcSinkPipelineToSqlServerIT
extends AbstractJdbcSinkPipelineIT {
    @TestTemplate
    @ForSource(value={SourceType.SQLSERVER}, reason="SQL Server identity inserts")
    @SkipColumnTypePropagation
    public void testSqlServerIdentityInserts(Source source, Sink sink) throws Exception {
        String tableName = source.randomTableName();
        String sinkTableName = String.format("sqlserver_testDB_dbo_%s", tableName);
        String createSql = "CREATE TABLE %s (id integer identity(1,1) primary key, data varchar(50))";
        String sourceCreateSql = String.format("CREATE TABLE %s (id integer identity(1,1) primary key, data varchar(50))", tableName);
        String sinkCreateSql = String.format("CREATE TABLE %s (id integer identity(1,1) primary key, data varchar(50))", sinkTableName);
        String insertSql = String.format("INSERT INTO %s (data) values ('test')", tableName);
        this.registerSourceConnector(source, Collections.singletonList("varchar"), tableName, null, sourceCreateSql, insertSql);
        sink.execute(sinkCreateSql);
        Properties sinkProperties = this.getDefaultSinkConfig(sink);
        sinkProperties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        sinkProperties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        sinkProperties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        sinkProperties.put("dialect.sqlserver.identity.insert", "true");
        this.startSink(source, sinkProperties, tableName);
        this.consumeSinkRecord();
        sink.assertRows(sinkTableName, (ThrowingFunction<ResultSet, Void>)((ThrowingFunction)rs -> {
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(1);
            Assertions.assertThat((String)rs.getString(2)).isEqualTo((Object)"test");
            return null;
        }));
    }

    @Override
    protected String getBooleanType() {
        return "BIT";
    }

    @Override
    protected String getBitsDataType() {
        return "VARBINARY";
    }

    @Override
    protected String getInt8Type() {
        return "SMALLINT";
    }

    @Override
    protected String getInt16Type() {
        return "SMALLINT";
    }

    @Override
    protected String getInt32Type() {
        return "INT";
    }

    @Override
    protected String getInt64Type() {
        return "BIGINT";
    }

    @Override
    protected String getVariableScaleDecimalType() {
        return "FLOAT";
    }

    @Override
    protected String getDecimalType() {
        return "DECIMAL";
    }

    @Override
    protected String getFloat32Type() {
        return "REAL";
    }

    @Override
    protected String getFloat64Type() {
        return "FLOAT";
    }

    @Override
    protected String getCharType(Source source, boolean key, boolean nationalized) {
        if (source.getType().is(SourceType.MYSQL)) {
            if (source.getOptions().isColumnTypePropagated() && !key) {
                return nationalized ? "NCHAR" : "CHAR";
            }
            return nationalized ? "NVARCHAR" : "VARCHAR";
        }
        if (source.getOptions().isColumnTypePropagated() && !key) {
            return !nationalized ? "CHAR" : "NCHAR";
        }
        return "VARCHAR";
    }

    @Override
    protected String getStringType(Source source, boolean key, boolean nationalized, boolean maxLength) {
        if (source.getType().is(SourceType.MYSQL)) {
            return nationalized ? "NVARCHAR" : "VARCHAR";
        }
        if (source.getOptions().isColumnTypePropagated() && !key && nationalized) {
            return "NVARCHAR";
        }
        return "VARCHAR";
    }

    @Override
    protected String getTextType(boolean nationalized) {
        return "VARCHAR";
    }

    @Override
    protected String getBinaryType(Source source, String sourceDataType) {
        return "VARBINARY";
    }

    @Override
    protected String getJsonType(Source source) {
        return this.getStringType(source, false, false);
    }

    @Override
    protected String getXmlType(Source source) {
        if (source.getType() == SourceType.POSTGRES || source.getOptions().isColumnTypePropagated()) {
            return "XML";
        }
        return "VARCHAR";
    }

    @Override
    protected String getUuidType(Source source, boolean key) {
        return this.getStringType(source, key, false);
    }

    @Override
    protected String getEnumType(Source source, boolean key) {
        return this.getStringType(source, key, false);
    }

    @Override
    protected String getSetType(Source source, boolean key) {
        return this.getStringType(source, key, false);
    }

    @Override
    protected String getYearType() {
        return this.getInt32Type();
    }

    @Override
    protected String getDateType() {
        return "DATE";
    }

    @Override
    protected String getTimeType(Source source, boolean key, int precision) {
        return "TIME";
    }

    @Override
    protected String getTimeWithTimezoneType() {
        return "DATETIMEOFFSET";
    }

    @Override
    protected String getTimestampType(Source source, boolean key, int precision) {
        return "DATETIME2";
    }

    @Override
    protected String getTimestampWithTimezoneType(Source source, boolean key, int precision) {
        return "DATETIMEOFFSET";
    }

    @Override
    protected String getIntervalType(Source source, boolean numeric) {
        return numeric ? this.getInt64Type() : this.getStringType(source, false, false);
    }
}

