/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.util.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;

public class HstoreConverter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String jsonToString(String value) {
        if (Strings.isNullOrBlank((String)value)) {
            return null;
        }
        try {
            HashMap<String, String> hstoreMap = new HashMap<String, String>();
            JsonNode json = MAPPER.readTree(value);
            Iterator iterator = json.fieldNames();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                String fieldValue = json.get(fieldName).textValue();
                hstoreMap.put(fieldName, fieldValue);
            }
            return HstoreConverter.mapToString(hstoreMap);
        }
        catch (JsonProcessingException e) {
            throw new ConnectException("Failed to deserialize JSON to HSTORE", (Throwable)e);
        }
    }

    public static String mapToString(Map<String, String> hstoreMap) {
        if (hstoreMap == null) {
            return null;
        }
        return hstoreMap.entrySet().stream().map(entry -> HstoreConverter.formatHstoreEntry(entry)).collect(Collectors.joining(", "));
    }

    private static String formatHstoreEntry(Map.Entry<String, String> entry) {
        return String.format("\"%s\" => \"%s\"", entry.getKey(), entry.getValue());
    }
}

