/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.Buffer;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public class ReducedRecordBuffer
implements Buffer {
    private final JdbcSinkConnectorConfig connectorConfig;
    private Schema keySchema;
    private Schema valueSchema;
    private final Map<Struct, SinkRecordDescriptor> records = new HashMap<Struct, SinkRecordDescriptor>();

    public ReducedRecordBuffer(JdbcSinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public List<SinkRecordDescriptor> add(SinkRecordDescriptor recordDescriptor) {
        Struct keyStruct;
        List<Object> flushed = new ArrayList();
        boolean isSchemaChanged = false;
        if (this.records.isEmpty()) {
            this.keySchema = recordDescriptor.getKeySchema();
            this.valueSchema = recordDescriptor.getValueSchema();
        }
        if (!Objects.equals(this.keySchema, recordDescriptor.getKeySchema()) || !Objects.equals(this.valueSchema, recordDescriptor.getValueSchema())) {
            this.keySchema = recordDescriptor.getKeySchema();
            this.valueSchema = recordDescriptor.getValueSchema();
            flushed = this.flush();
            isSchemaChanged = true;
        }
        if ((keyStruct = recordDescriptor.getKeyStruct(this.connectorConfig.getPrimaryKeyMode())) == null) {
            throw new ConnectException("No struct-based primary key defined for record key/value, reduction buffer require struct based primary key");
        }
        this.records.put(keyStruct, recordDescriptor);
        if (isSchemaChanged) {
            return flushed;
        }
        if ((long)this.records.size() >= this.connectorConfig.getBatchSize()) {
            flushed = this.flush();
        }
        return flushed;
    }

    @Override
    public List<SinkRecordDescriptor> flush() {
        ArrayList<SinkRecordDescriptor> flushed = new ArrayList<SinkRecordDescriptor>(this.records.values());
        this.records.clear();
        return flushed;
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }
}

