/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.Buffer;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.SinkRecordDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;

public class RecordBuffer
implements Buffer {
    private final JdbcSinkConnectorConfig connectorConfig;
    private Schema keySchema;
    private Schema valueSchema;
    private final ArrayList<SinkRecordDescriptor> records = new ArrayList();

    public RecordBuffer(JdbcSinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public List<SinkRecordDescriptor> add(SinkRecordDescriptor recordDescriptor) {
        List<Object> flushed = new ArrayList();
        boolean isSchemaChanged = false;
        if (this.records.isEmpty()) {
            this.keySchema = recordDescriptor.getKeySchema();
            this.valueSchema = recordDescriptor.getValueSchema();
        }
        if (!Objects.equals(this.keySchema, recordDescriptor.getKeySchema()) || !Objects.equals(this.valueSchema, recordDescriptor.getValueSchema())) {
            this.keySchema = recordDescriptor.getKeySchema();
            this.valueSchema = recordDescriptor.getValueSchema();
            flushed = this.flush();
            isSchemaChanged = true;
        }
        this.records.add(recordDescriptor);
        if (isSchemaChanged) {
            return flushed;
        }
        if ((long)this.records.size() >= this.connectorConfig.getBatchSize()) {
            flushed = this.flush();
        }
        return flushed;
    }

    @Override
    public List<SinkRecordDescriptor> flush() {
        ArrayList<SinkRecordDescriptor> flushed = new ArrayList<SinkRecordDescriptor>(this.records);
        this.records.clear();
        return flushed;
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }
}

