/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.db2.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.db2.debezium.AbstractDebeziumTimeType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import java.time.LocalTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public class NanoTimeType
extends AbstractDebeziumTimeType {
    public static final NanoTimeType INSTANCE = new NanoTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.NanoTime"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0) {
            precision = Math.min(precision, dialect.getMaxTimePrecision());
            return dialect.getTypeName(92, Size.precision((int)precision));
        }
        return dialect.getTypeName(92, Size.precision((int)dialect.getMaxTimePrecision()));
    }

    @Override
    protected LocalTime getLocalTime(Number value) {
        return DateTimeUtils.toLocalTimeFromDurationNanoseconds(value.longValue());
    }
}

