/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter.e2e.source;

import io.debezium.connector.jdbc.junit.PostgresExtensionUtils;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.WithPostgresExtension;
import io.debezium.connector.jdbc.junit.jupiter.e2e.ForSource;
import io.debezium.connector.jdbc.junit.jupiter.e2e.ForSourceNoMatrix;
import io.debezium.connector.jdbc.junit.jupiter.e2e.SkipColumnTypePropagation;
import io.debezium.connector.jdbc.junit.jupiter.e2e.SkipExtractNewRecordState;
import io.debezium.connector.jdbc.junit.jupiter.e2e.SkipWhenSource;
import io.debezium.connector.jdbc.junit.jupiter.e2e.SkipWhenSources;
import io.debezium.connector.jdbc.junit.jupiter.e2e.WithTemporalPrecisionMode;
import io.debezium.connector.jdbc.junit.jupiter.e2e.source.Source;
import io.debezium.connector.jdbc.junit.jupiter.e2e.source.SourceConnectorOptions;
import io.debezium.connector.jdbc.junit.jupiter.e2e.source.SourceType;
import io.debezium.connector.jdbc.util.RandomTableNameGenerator;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.testing.testcontainers.DebeziumContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public class SourcePipelineInvocationContextProvider
implements BeforeAllCallback,
AfterAllCallback,
TestTemplateInvocationContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourcePipelineInvocationContextProvider.class);
    private static final String KAFKA_IMAGE_NAME = "confluentinc/cp-kafka";
    private static final String CONNECT_IMAGE_NAME = "debezium/connect-with-oracle";
    private static final String MYSQL_IMAGE_NAME = "debezium/example-mysql";
    private static final String MYSQL_USERNAME = "mysqluser";
    private static final String MYSQL_PASSWORD = "debezium";
    private static final String POSTGRES_IMAGE_NAME = "debezium/example-postgres";
    private static final String POSTGRES_USERNAME = "postgres";
    private static final String POSTGRES_PASSWORD = "postgres";
    private static final String SQLSERVER_IMAGE_NAME = "mcr.microsoft.com/mssql/server:2022-latest";
    private static final String SQLSERVER_PASSWORD = "Debezium1!";
    private static final String ORACLE_IMAGE_NAME = "quay.io/rh_integration/dbz-oracle:19.3.0";
    private static final String ORACLE_USERNAME = "debezium";
    private static final String ORACLE_PASSWORD = "dbz";
    private static final String DB2_IMAGE_NAME = "ibmcom/db2:11.5.0.0a";
    private static final Network network = Network.newNetwork();
    private final RandomTableNameGenerator tableNameGenerator = new RandomTableNameGenerator();
    private final KafkaContainer kafkaContainer = this.getKafkaContainer();
    private final DebeziumContainer connectContainer = this.getKafkaConnectContainer(this.kafkaContainer);
    private final Map<SourceType, JdbcDatabaseContainer<?>> sourceContainers = this.getSourceContainers();

    public void beforeAll(ExtensionContext context) throws Exception {
        Stream.Builder<Object> startables = Stream.builder();
        startables.add(this.kafkaContainer);
        startables.add(this.connectContainer);
        this.sourceContainers.values().forEach(startables::add);
        Startables.deepStart(startables.build()).join();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.sourceContainers.values().forEach(GenericContainer::stop);
        this.connectContainer.stop();
        this.kafkaContainer.stop();
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        SkipWhenSource skipWhenSource = method.getAnnotation(SkipWhenSource.class);
        SkipWhenSources skipWhenSources = method.getAnnotation(SkipWhenSources.class);
        ForSource forSource = method.getAnnotation(ForSource.class);
        ForSourceNoMatrix forSourceNoMatrix = method.getAnnotation(ForSourceNoMatrix.class);
        WithPostgresExtension postgresExtensionAnn = method.getAnnotation(WithPostgresExtension.class);
        String postgresExtension = Objects.isNull(postgresExtensionAnn) ? null : postgresExtensionAnn.value();
        boolean streamEmpty = true;
        Stream.Builder<TestTemplateInvocationContext> builder = Stream.builder();
        for (SourceType sourceType : this.sourceContainers.keySet()) {
            if (this.isSkipped(skipWhenSource, skipWhenSources, sourceType)) {
                LOGGER.info("Skipped source connector {}, @SkipWhenSource detected.", (Object)sourceType);
                continue;
            }
            if (forSource != null && !Arrays.asList(forSource.value()).contains((Object)sourceType)) {
                LOGGER.info("Skipped source connector {}, @ForSource does not include it.", (Object)sourceType);
                continue;
            }
            if (forSourceNoMatrix != null && !Arrays.asList(forSourceNoMatrix.value()).contains((Object)sourceType)) {
                LOGGER.info("Skipped source connector {}, @ForSourceNoMatrix does not include it.", (Object)sourceType);
                continue;
            }
            for (Boolean flatten : this.getExtractNewRecordStateValues(method)) {
                for (Boolean propagateColumnTypes : this.getPropagateColumnTypeValues(method)) {
                    for (TemporalPrecisionMode temporalPrecisionMode : this.getTemporalPrecisionModes(method, sourceType)) {
                        builder.add(this.createInvocationContext(context, sourceType, flatten, propagateColumnTypes, temporalPrecisionMode, postgresExtension));
                        streamEmpty = false;
                    }
                }
            }
        }
        if (streamEmpty) {
            builder.add(new TestTemplateInvocationContext(){

                public String getDisplayName(int invocationIndex) {
                    return "skip-no-sources-available";
                }

                public List<Extension> getAdditionalExtensions() {
                    return List.of(context1 -> ConditionEvaluationResult.disabled((String)"No sources available"));
                }
            });
        }
        return builder.build();
    }

    private boolean isSkipped(SkipWhenSource skipWhenSource, SkipWhenSources skipWhenSources, SourceType sourceType) {
        if (skipWhenSources != null) {
            for (SkipWhenSource skipWhenSourceChild : skipWhenSources.value()) {
                if (!this.isSkipped(skipWhenSourceChild, null, sourceType)) continue;
                return true;
            }
        }
        if (skipWhenSource != null) {
            return Arrays.asList(skipWhenSource.value()).contains((Object)sourceType);
        }
        return false;
    }

    private List<Boolean> getExtractNewRecordStateValues(Method method) {
        if (this.isAnyAnnotationPresent(method.getDeclaringClass(), SkipExtractNewRecordState.class) || this.isAnyAnnotationPresent(method, SkipExtractNewRecordState.class, ForSourceNoMatrix.class)) {
            return List.of(Boolean.valueOf(false));
        }
        return List.of(Boolean.valueOf(false), Boolean.valueOf(true));
    }

    private List<Boolean> getPropagateColumnTypeValues(Method method) {
        if (this.isAnyAnnotationPresent(method.getDeclaringClass(), SkipColumnTypePropagation.class) || this.isAnyAnnotationPresent(method, SkipColumnTypePropagation.class, ForSourceNoMatrix.class)) {
            return List.of(Boolean.valueOf(false));
        }
        return List.of(Boolean.valueOf(false), Boolean.valueOf(true));
    }

    private List<TemporalPrecisionMode> getTemporalPrecisionModes(Method method, SourceType sourceType) {
        if (this.isAnyAnnotationPresent(method, WithTemporalPrecisionMode.class)) {
            ArrayList<TemporalPrecisionMode> result = new ArrayList<TemporalPrecisionMode>();
            for (TemporalPrecisionMode temporalPrecisionMode : TemporalPrecisionMode.values()) {
                if (TemporalPrecisionMode.ADAPTIVE == temporalPrecisionMode && SourceType.MYSQL == sourceType) continue;
                result.add(temporalPrecisionMode);
            }
            return result;
        }
        return Collections.singletonList(TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS);
    }

    @SafeVarargs
    private boolean isAnyAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (!element.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    private TestTemplateInvocationContext createInvocationContext(final ExtensionContext context, final SourceType sourceType, final boolean flatten, final boolean propagateTypes, final TemporalPrecisionMode temporalPrecisionMode, final String postgresExtension) {
        SourceConnectorOptions sourceOptions = new SourceConnectorOptions(){

            @Override
            public boolean useSnapshot() {
                return TestHelper.isSourceSnapshot();
            }

            @Override
            public boolean useDefaultValues() {
                return TestHelper.isDefaultValuesEnabled();
            }

            @Override
            public boolean isFlatten() {
                return flatten;
            }

            @Override
            public boolean isColumnTypePropagated() {
                return propagateTypes;
            }

            @Override
            public TemporalPrecisionMode getTemporalPrecisionMode() {
                return temporalPrecisionMode;
            }
        };
        final JdbcDatabaseContainer<?> sourceContainer = this.sourceContainers.get((Object)sourceType);
        final Source source = new Source(sourceType, sourceContainer, this.kafkaContainer, this.connectContainer, sourceOptions, this.tableNameGenerator);
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return "source-" + sourceType + "-[flat=" + flatten + ",propagate=" + propagateTypes + ",temporal=" + temporalPrecisionMode + "]";
            }

            public List<Extension> getAdditionalExtensions() {
                Method method = context.getRequiredTestMethod();
                Class testClass = context.getRequiredTestClass();
                return Arrays.asList(context -> {
                    LOGGER.info("Running test {}.{}: {}", new Object[]{testClass.getName(), method.getName(), this.getDisplayName(0)});
                    if (!sourceContainer.isRunning()) {
                        sourceContainer.start();
                    }
                    if (sourceType.is(SourceType.POSTGRES)) {
                        PostgresExtensionUtils.createExtension(source, postgresExtension);
                    }
                }, context -> {
                    SourcePipelineInvocationContextProvider.this.connectContainer.deleteAllConnectors();
                    source.waitUntilDeleted();
                    if (sourceType.is(SourceType.POSTGRES)) {
                        PostgresExtensionUtils.dropExtension(source, postgresExtension);
                    }
                    source.close();
                    if (context.getExecutionException().isPresent()) {
                        LOGGER.error("Test {}.{}: {} failed with exception:", new Object[]{testClass.getName(), method.getName(), this.getDisplayName(0), context.getExecutionException().get()});
                    }
                }, new ParameterResolver(){

                    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                        return parameterContext.getParameter().getType() == Source.class;
                    }

                    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                        return source;
                    }
                });
            }
        };
    }

    private KafkaContainer getKafkaContainer() {
        return (KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)KAFKA_IMAGE_NAME)).withNetwork(network)).withNetworkAliases(new String[]{"kafka"});
    }

    private DebeziumContainer getKafkaConnectContainer(KafkaContainer kafkaContainer) {
        Path dockerFile = Paths.get("src", "test", "docker", "debezium-connect-with-oracle-driver").toFile().getAbsoluteFile().toPath();
        return (DebeziumContainer)((DebeziumContainer)new DebeziumContainer((Future)new ImageFromDockerfile().withFileFromPath(".", dockerFile)).withKafka(kafkaContainer).withNetwork(network)).withNetworkAliases(new String[]{"connect"});
    }

    private Map<SourceType, JdbcDatabaseContainer<?>> getSourceContainers() {
        LinkedHashMap containers = new LinkedHashMap();
        for (SourceType sourceType : this.getSourcesToStart()) {
            JdbcDatabaseContainer container;
            if (SourceType.MYSQL.equals((Object)sourceType)) {
                container = (JdbcDatabaseContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(DockerImageName.parse((String)MYSQL_IMAGE_NAME).asCompatibleSubstituteFor("mysql")).withNetwork(network)).withUsername(MYSQL_USERNAME).withPassword("debezium").withNetworkAliases(new String[]{sourceType.getValue()})).withEnv("TZ", TestHelper.getSourceTimeZone());
                if (TestHelper.isConnectionTimeZoneUsed()) {
                    container.withUrlParam("connectionTimeZone", TestHelper.getSourceTimeZone());
                }
                containers.put(sourceType, container);
                continue;
            }
            if (SourceType.POSTGRES.equals((Object)sourceType)) {
                container = (JdbcDatabaseContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)POSTGRES_IMAGE_NAME).asCompatibleSubstituteFor("postgres")).withNetwork(network)).withUsername("postgres").withPassword("postgres").withNetworkAliases(new String[]{sourceType.getValue()})).withEnv("TZ", TestHelper.getSourceTimeZone())).withEnv("PGTZ", TestHelper.getSourceTimeZone());
                containers.put(sourceType, container);
                continue;
            }
            if (SourceType.SQLSERVER.equals((Object)sourceType)) {
                container = (JdbcDatabaseContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)new MSSQLServerContainer(DockerImageName.parse((String)SQLSERVER_IMAGE_NAME)).withNetwork(network)).acceptLicense().withEnv("MSSQL_AGENT_ENABLED", "true")).withEnv("MSSQL_PID", "Standard")).withPassword(SQLSERVER_PASSWORD).withInitScript("database-init-scripts/sqlserver-source-init.sql")).withNetworkAliases(new String[]{sourceType.getValue()})).withEnv("TZ", TestHelper.getSourceTimeZone());
                containers.put(sourceType, container);
                continue;
            }
            if (!SourceType.ORACLE.equals((Object)sourceType)) continue;
            container = (JdbcDatabaseContainer)((OracleContainer)((OracleContainer)new OracleContainer(DockerImageName.parse((String)ORACLE_IMAGE_NAME).asCompatibleSubstituteFor("gvenzl/oracle-xe")).withNetwork(network)).withUsername("debezium").withPassword(ORACLE_PASSWORD).withDatabaseName("ORCLPDB1").withNetworkAliases(new String[]{sourceType.getValue()})).withEnv("TZ", TestHelper.getSourceTimeZone());
            containers.put(sourceType, container);
        }
        return containers;
    }

    private List<SourceType> getSourcesToStart() {
        String sourceConnectors = System.getProperty("source.connectors");
        if (sourceConnectors == null || sourceConnectors.isEmpty()) {
            return List.of(SourceType.MYSQL, SourceType.POSTGRES, SourceType.SQLSERVER);
        }
        return Arrays.stream(sourceConnectors.split(",")).map(SourceType::parse).collect(Collectors.toList());
    }
}

