/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.db2;

import io.debezium.connector.jdbc.integration.AbstractJdbcSinkDeleteEnabledTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.Db2SinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import java.sql.SQLException;
import org.assertj.db.api.TableAssert;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-db2")})
@ExtendWith(value={Db2SinkDatabaseContextProvider.class})
public class JdbcSinkDeleteEnabledIT
extends AbstractJdbcSinkDeleteEnabledTest {
    public JdbcSinkDeleteEnabledIT(Sink sink) {
        super(sink);
    }

    @Test
    public void testShouldHandleTruncateTableStatementWithoutHibernate() throws SQLException {
        Sink sink = this.getSink();
        sink.execute("create table TEST_TRUNCATE_DB2_TABLE(id int not null, name varchar(255), primary key(id))");
        sink.execute("insert into TEST_TRUNCATE_DB2_TABLE(id,name) values(1,'jdbc')");
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), "TEST_TRUNCATE_DB2_TABLE");
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(2);
        sink.execute("truncate table TEST_TRUNCATE_DB2_TABLE IMMEDIATE");
        tableAssert = TestHelper.assertTable(this.dataSource(), "TEST_TRUNCATE_DB2_TABLE");
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(2);
    }
}

