/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.type.ValueType;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public abstract class AbstractJdbcSinkDeleteEnabledTest
extends AbstractJdbcSinkTest {
    public AbstractJdbcSinkDeleteEnabledTest(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testShouldNotDeleteRowWhenDeletesDisabled(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("delete.enabled", "false");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        this.consume(factory.deleteRecord(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testShouldDeleteRowWhenDeletesEnabled(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("delete.enabled", "true");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        this.consume(factory.deleteRecord(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testShouldDeleteRowWhenDeletesEnabledUsingSubsetOfRecordKeyFields(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("primary.key.fields", "id2");
        properties.put("delete.enabled", "true");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecordMultipleKeyColumns(topicName);
        this.consume(createRecord);
        this.consume(factory.deleteRecordMultipleKeyColumns(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id1", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "id2", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testShouldHandleRowDeletionWhenRowDoesNotExist(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("delete.enabled", "true");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord deleteRecord = factory.deleteRecord(topicName);
        this.consume(deleteRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(deleteRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    public void testShouldHandleRowDeletionWhenRowDoesNotExistUsingSubsetOfRecordKeyFields(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("primary.key.fields", "id2");
        properties.put("delete.enabled", "true");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord deleteRecord = factory.deleteRecordMultipleKeyColumns(topicName);
        this.consume(deleteRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(deleteRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id1", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "id2", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6862"})
    public void testShouldSkipTombstoneRecord(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("delete.enabled", "true");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord deleteRecord = factory.deleteRecord(topicName);
        this.consume(factory.tombstoneRecord(topicName));
        this.consume(deleteRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(deleteRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6970"})
    public void testShouldSkipTruncateRecord(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("truncate.enabled", "false");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        this.consume(factory.truncateRecord(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(3);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6970"})
    public void testShouldHandleTruncateRecord(SinkRecordFactory factory) {
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue());
        properties.put("truncate.enabled", "true");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        SinkRecord createRecord = factory.createRecord(topicName);
        this.consume(createRecord);
        this.consume(factory.truncateRecord(topicName));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        if (factory.isFlattened()) {
            ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(3);
            this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
            this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
            this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$");
        } else {
            ((TableAssert)tableAssert.exists().hasNumberOfRows(0)).hasNumberOfColumns(3);
        }
    }
}

