/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.naming.DefaultTableNamingStrategy;
import io.debezium.connector.jdbc.util.DebeziumSinkRecordFactory;
import io.debezium.doc.FixFor;
import java.util.Map;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="UnitTests")
public class TableNamingStrategyTest {
    @Test
    public void testDefaultTableNamingStrategy() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of());
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        Assertions.assertThat((String)strategy.resolveTableName(config, factory.createRecord("database.schema.table"))).isEqualTo((Object)"database_schema_table");
    }

    @Test
    public void testTableNamingStrategyWithTableNameFormat() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "kafka_${topic}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        Assertions.assertThat((String)strategy.resolveTableName(config, factory.createRecord("database.schema.table"))).isEqualTo((Object)"kafka_database_schema_table");
    }

    @Test
    @FixFor(value={"DBZ-6491"})
    public void testTableNamingStrategyWithPrependedSchema() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "SYS.${topic}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        Assertions.assertThat((String)strategy.resolveTableName(config, factory.createRecord("database.schema.table"))).isEqualTo((Object)"SYS.database_schema_table");
    }

    @Test
    public void testDefaultTableNamingStrategyWithDebeziumSource() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "source_${source.db}_${source.schema}_${source.table}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        SinkRecord sinkRecord = factory.createRecord("database.schema.table", (byte)1, "database1", "schema1", "table1");
        Assertions.assertThat((String)strategy.resolveTableName(config, sinkRecord)).isEqualTo((Object)"source_database1_schema1_table1");
    }

    @Test
    public void testDefaultTableNamingStrategyWithInvalidSourceField() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "source_${source.invalid}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        SinkRecord sinkRecord = factory.createRecord("database.schema.table", (byte)1, "database1", "schema1", "table1");
        org.junit.jupiter.api.Assertions.assertThrows(DataException.class, () -> strategy.resolveTableName(config, sinkRecord));
    }

    @Test
    public void testDefaultTableNamingStrategyWithDebeziumSourceAndTombstone() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "source_${source.db}_${source.schema}_${source.table}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        SinkRecord sinkRecord = factory.tombstoneRecord("database.schema.table");
        Assertions.assertThat((String)strategy.resolveTableName(config, sinkRecord)).isNull();
    }

    @Test
    public void testDefaultTableNamingStrategyWithTopicAndTombstone() {
        JdbcSinkConnectorConfig config = new JdbcSinkConnectorConfig(Map.of("table.name.format", "kafka_${topic}"));
        DebeziumSinkRecordFactory factory = new DebeziumSinkRecordFactory();
        DefaultTableNamingStrategy strategy = new DefaultTableNamingStrategy();
        SinkRecord sinkRecord = factory.tombstoneRecord("database.schema.table");
        Assertions.assertThat((String)strategy.resolveTableName(config, sinkRecord)).isEqualTo((Object)"kafka_database_schema_table");
    }
}

