/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SqmMutationStrategyHelper {
    private SqmMutationStrategyHelper() {
    }

    public static void visitCollectionTables(EntityMappingType entityDescriptor, Consumer<PluralAttributeMapping> consumer) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                consumer.accept((PluralAttributeMapping)attributeMapping);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTables((EmbeddedAttributeMapping)attributeMapping, consumer);
            }
        });
    }

    private static void visitCollectionTables(EmbeddedAttributeMapping attributeMapping, Consumer<PluralAttributeMapping> consumer) {
        attributeMapping.visitSubParts(modelPart -> {
            if (modelPart instanceof PluralAttributeMapping) {
                consumer.accept((PluralAttributeMapping)modelPart);
            } else if (modelPart instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.visitCollectionTables((EmbeddedAttributeMapping)modelPart, consumer);
            }
        }, null);
    }

    public static void cleanUpCollectionTables(EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return;
        }
        entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTables((EmbeddedAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            }
        });
    }

    private static void cleanUpCollectionTables(EmbeddedAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        attributeMapping.visitSubParts(modelPart -> {
            if (modelPart instanceof PluralAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)modelPart, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            } else if (modelPart instanceof EmbeddedAttributeMapping) {
                SqmMutationStrategyHelper.cleanUpCollectionTables((EmbeddedAttributeMapping)modelPart, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
            }
        }, null);
    }

    private static void cleanUpCollectionTable(PluralAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        String separateCollectionTable = attributeMapping.getSeparateCollectionTable();
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        if (separateCollectionTable != null) {
            NamedTableReference tableReference = new NamedTableReference(separateCollectionTable, "to_delete_", true);
            DeleteStatement sqlAstDelete = new DeleteStatement(tableReference, restrictionProducer.apply(tableReference, attributeMapping));
            jdbcServices.getJdbcMutationExecutor().execute(jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(sessionFactory, sqlAstDelete).translate(jdbcParameterBindings, executionContext.getQueryOptions()), jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
    }

    public static Predicate getIdSubqueryPredicate(Predicate predicate, EntityMappingType entityDescriptor, TableGroup tableGroup, SharedSessionContractImplementor session) {
        Junction original;
        if (predicate instanceof FilterPredicate || predicate instanceof SqlFragmentPredicate) {
            return SqmMutationStrategyHelper.getBaseRestrictions(entityDescriptor, tableGroup, session).get(0);
        }
        if (predicate instanceof Junction && (original = (Junction)predicate).getPredicates().size() > 1) {
            Object baseRestrictions;
            Junction junction = new Junction(original.getNature(), original.getExpressionType());
            junction.getPredicates().addAll(original.getPredicates());
            Predicate secondToLastPredicate = junction.getPredicates().get(junction.getPredicates().size() - 2);
            Predicate lastPredicate = junction.getPredicates().get(junction.getPredicates().size() - 1);
            int filterPredicateIndex = -1;
            int fragmentPredicateIndex = -1;
            if (lastPredicate instanceof Junction) {
                baseRestrictions = SqmMutationStrategyHelper.getIdSubqueryPredicate(lastPredicate, entityDescriptor, tableGroup, session);
                junction.getPredicates().set(junction.getPredicates().size() - 1, (Predicate)baseRestrictions);
                predicate = junction;
            } else if (secondToLastPredicate instanceof FilterPredicate) {
                filterPredicateIndex = junction.getPredicates().size() - 2;
                fragmentPredicateIndex = filterPredicateIndex + 1;
            } else if (lastPredicate instanceof FilterPredicate) {
                filterPredicateIndex = junction.getPredicates().size() - 1;
            } else if (lastPredicate instanceof SqlFragmentPredicate) {
                fragmentPredicateIndex = junction.getPredicates().size() - 1;
            }
            if (filterPredicateIndex != -1 || fragmentPredicateIndex != -1) {
                baseRestrictions = SqmMutationStrategyHelper.getBaseRestrictions(entityDescriptor, tableGroup, session);
                int index = 0;
                if (filterPredicateIndex != -1) {
                    junction.getPredicates().set(filterPredicateIndex, (Predicate)baseRestrictions.get(index++));
                }
                if (fragmentPredicateIndex != -1) {
                    junction.getPredicates().set(fragmentPredicateIndex, (Predicate)baseRestrictions.get(index));
                }
                predicate = junction;
            }
        }
        return predicate;
    }

    private static List<Predicate> getBaseRestrictions(EntityMappingType entityDescriptor, TableGroup tableGroup, SharedSessionContractImplementor session) {
        ArrayList<Predicate> baseRestrictions = new ArrayList<Predicate>(2);
        entityDescriptor.applyBaseRestrictions(baseRestrictions::add, tableGroup, true, session.getLoadQueryInfluencers().getEnabledFilters(), null, null);
        return baseRestrictions;
    }
}

