/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.converters.spi.SerializerType;
import io.debezium.data.Envelope;
import io.debezium.util.Strings;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;

public class SinkRecordBuilder {
    private SinkRecordBuilder() {
    }

    public static SinkRecordTypeBuilder create() {
        return new SinkRecordTypeBuilder(Type.CREATE);
    }

    public static SinkRecordTypeBuilder update() {
        return new SinkRecordTypeBuilder(Type.UPDATE);
    }

    public static SinkRecordTypeBuilder delete() {
        return new SinkRecordTypeBuilder(Type.DELETE);
    }

    public static SinkRecordTypeBuilder tombstone() {
        return new SinkRecordTypeBuilder(Type.TOMBSTONE);
    }

    public static SinkRecordTypeBuilder truncate() {
        return new SinkRecordTypeBuilder(Type.TRUNCATE);
    }

    public static SinkRecordTypeBuilder cloudEvent() {
        return new SinkRecordTypeBuilder(Type.CLOUD_EVENT);
    }

    public static class SinkRecordTypeBuilder {
        private final Type type;
        private boolean flat;
        private String topicName;
        private String name;
        private Schema keySchema;
        private Schema recordSchema;
        private Schema sourceSchema;
        private int partition;
        private int offset;
        private SinkRecord baseRecord;
        private SerializerType cloudEventsSerializerType;
        private String cloudEventsSchemaName;
        private Map<String, Object> keyValues = new HashMap<String, Object>();
        private Map<String, Object> beforeValues = new HashMap<String, Object>();
        private Map<String, Object> afterValues = new HashMap<String, Object>();
        private Map<String, Object> sourceValues = new HashMap<String, Object>();

        private SinkRecordTypeBuilder(Type type) {
            this.type = type;
        }

        public SinkRecordTypeBuilder flat(boolean flat) {
            this.flat = flat;
            return this;
        }

        public SinkRecordTypeBuilder topic(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public SinkRecordTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SinkRecordTypeBuilder keySchema(Schema keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        public SinkRecordTypeBuilder key(String fieldName, Object value) {
            this.keyValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder recordSchema(Schema recordSchema) {
            this.recordSchema = recordSchema;
            return this;
        }

        public SinkRecordTypeBuilder before(String fieldName, Object value) {
            this.beforeValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder after(String fieldName, Object value) {
            this.afterValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder sourceSchema(Schema sourceSchema) {
            this.sourceSchema = sourceSchema;
            return this;
        }

        public SinkRecordTypeBuilder source(String fieldName, Object value) {
            this.sourceValues.put(fieldName, value);
            return this;
        }

        public SinkRecordTypeBuilder partition(int partition) {
            this.partition = partition;
            return this;
        }

        public SinkRecordTypeBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public SinkRecordTypeBuilder baseRecord(SinkRecord baseRecord) {
            this.baseRecord = baseRecord;
            return this;
        }

        public SinkRecordTypeBuilder cloudEventsSerializerType(SerializerType serializerType) {
            this.cloudEventsSerializerType = serializerType;
            return this;
        }

        public SinkRecordTypeBuilder cloudEventsSchemaName(String cloudEventsSchemaName) {
            this.cloudEventsSchemaName = cloudEventsSchemaName;
            return this;
        }

        public SinkRecord build() {
            switch (this.type) {
                case CREATE: {
                    return this.buildCreateSinkRecord();
                }
                case UPDATE: {
                    return this.buildUpdateSinkRecord();
                }
                case DELETE: {
                    return this.buildDeleteSinkRecord();
                }
                case TOMBSTONE: {
                    return this.buildTombstoneSinkRecord();
                }
                case TRUNCATE: {
                    return this.buildTruncateSinkRecord();
                }
                case CLOUD_EVENT: {
                    return this.buildCloudEventRecord();
                }
            }
            return null;
        }

        private SinkRecord buildCreateSinkRecord() {
            Objects.requireNonNull(this.recordSchema, "A record schema must be provided.");
            Objects.requireNonNull(this.sourceSchema, "A source schema must be provided.");
            Struct key = this.populateStructForKey();
            Struct after = this.populateStructFromMap(new Struct(this.recordSchema), this.afterValues);
            Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
            if (!this.flat) {
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.create((Object)after, source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, this.recordSchema, (Object)after, (long)this.offset);
        }

        private SinkRecord buildUpdateSinkRecord() {
            Objects.requireNonNull(this.recordSchema, "A record schema must be provided.");
            Objects.requireNonNull(this.sourceSchema, "A source schema must be provided.");
            Struct key = this.populateStructForKey();
            Struct before = this.populateStructFromMap(new Struct(this.recordSchema), this.beforeValues);
            Struct after = this.populateStructFromMap(new Struct(this.recordSchema), this.afterValues);
            Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
            if (!this.flat) {
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.update((Object)before, after, source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, this.recordSchema, (Object)after, (long)this.offset);
        }

        private SinkRecord buildDeleteSinkRecord() {
            Objects.requireNonNull(this.recordSchema, "A record schema must be provided.");
            Objects.requireNonNull(this.sourceSchema, "A source schema must be provided.");
            Struct key = this.populateStructForKey();
            Struct before = this.populateStructFromMap(new Struct(this.recordSchema), this.beforeValues);
            Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
            if (!this.flat) {
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.delete((Object)before, source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, this.recordSchema, null, (long)this.offset);
        }

        private SinkRecord buildTombstoneSinkRecord() {
            Struct key = this.populateStructForKey();
            return new SinkRecord(this.topicName, this.partition, this.keySchema, (Object)key, null, null, (long)this.offset);
        }

        private SinkRecord buildTruncateSinkRecord() {
            if (!this.flat) {
                Struct source = this.populateStructFromMap(new Struct(this.sourceSchema), this.sourceValues);
                Envelope envelope = this.createEnvelope();
                Struct payload = envelope.truncate(source, Instant.now());
                return new SinkRecord(this.topicName, this.partition, null, null, envelope.schema(), (Object)payload, (long)this.offset);
            }
            return null;
        }

        private SinkRecord buildCloudEventRecord() {
            Object ceValue;
            String schemaName = this.cloudEventsSchemaName != null ? this.cloudEventsSchemaName : "test.test.CloudEvents.Envelope";
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(schemaName).field("id", Schema.STRING_SCHEMA).field("source", Schema.STRING_SCHEMA).field("specversion", Schema.STRING_SCHEMA).field("type", Schema.STRING_SCHEMA).field("time", Schema.STRING_SCHEMA).field("datacontenttype", Schema.STRING_SCHEMA).field("data", this.baseRecord.valueSchema());
            Schema ceSchema = schemaBuilder.build();
            Struct ceValueStruct = new Struct(ceSchema);
            ceValueStruct.put("id", (Object)Uuid.randomUuid().toString());
            ceValueStruct.put("source", (Object)"test_ce_source");
            ceValueStruct.put("specversion", (Object)"1.0");
            ceValueStruct.put("type", (Object)"TestType");
            ceValueStruct.put("time", (Object)LocalDateTime.now().toString());
            ceValueStruct.put("datacontenttype", (Object)"application/json");
            ceValueStruct.put("data", this.baseRecord.value());
            if (this.cloudEventsSerializerType == SerializerType.JSON) {
                ceValue = this.convertCloudEventToMap(ceSchema, ceValueStruct);
                ceSchema = null;
            } else {
                ceValue = ceValueStruct;
            }
            return new SinkRecord(this.baseRecord.topic(), this.baseRecord.kafkaPartition().intValue(), this.baseRecord.keySchema(), this.baseRecord.key(), ceSchema, ceValue, this.baseRecord.kafkaOffset(), this.baseRecord.timestamp(), this.baseRecord.timestampType(), (Iterable)this.baseRecord.headers());
        }

        private Envelope createEnvelope() {
            return Envelope.defineSchema().withRecord(this.recordSchema).withSource(this.sourceSchema).withName((Strings.isNullOrBlank((String)this.name) ? "dummy" : this.name) + ".Envelope").build();
        }

        private Struct populateStructFromMap(Struct struct, Map<String, Object> values) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                struct.put(entry.getKey(), entry.getValue());
            }
            return struct;
        }

        private Struct populateStructForKey() {
            if (this.keySchema != null) {
                return this.populateStructFromMap(new Struct(this.keySchema), this.keyValues);
            }
            return null;
        }

        private Map<String, Object> convertCloudEventToMap(Schema ceSchema, Struct ceValueStruct) {
            Map map;
            byte[] cloudEventJson;
            try (JsonConverter jsonConverter = new JsonConverter();){
                HashMap<String, Object> jsonDataConverterConfig = new HashMap<String, Object>();
                jsonDataConverterConfig.put("schemas.enable", false);
                jsonDataConverterConfig.put("converter.type", "value");
                jsonConverter.configure(jsonDataConverterConfig);
                cloudEventJson = jsonConverter.fromConnectData(null, ceSchema, (Object)ceValueStruct);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                map = (Map)objectMapper.readValue(cloudEventJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new DataException("Failed to instantiate map from CloudEvent JSON");
            }
            Object dataMap = map.get("data");
            if (dataMap != null) {
                map.put("data", dataMap.toString());
            }
            return map;
        }
    }

    private static enum Type {
        CREATE,
        UPDATE,
        DELETE,
        TOMBSTONE,
        TRUNCATE,
        CLOUD_EVENT;

    }
}

