/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.junit.jupiter;

import io.debezium.connector.jdbc.junit.PostgresExtensionUtils;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.AbstractSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.SinkType;
import io.debezium.connector.jdbc.junit.jupiter.WithPostgresExtension;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresSinkDatabaseContextProvider
extends AbstractSinkDatabaseContextProvider
implements BeforeEachCallback,
AfterEachCallback {
    private static final DockerImageName IMAGE_NAME = DockerImageName.parse((String)"debezium/postgres").asCompatibleSubstituteFor("postgres");

    public PostgresSinkDatabaseContextProvider() {
        super(SinkType.POSTGRES, (JdbcDatabaseContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(IMAGE_NAME).withNetwork(Network.newNetwork())).withDatabaseName("test").withEnv("TZ", TestHelper.getSinkTimeZone())).withEnv("PGTZ", TestHelper.getSinkTimeZone()));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Method method = context.getRequiredTestMethod();
        WithPostgresExtension postgresExtension = method.getAnnotation(WithPostgresExtension.class);
        if (postgresExtension != null) {
            PostgresExtensionUtils.createExtension(this.getSink(), postgresExtension.value());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Method method = context.getRequiredTestMethod();
        WithPostgresExtension postgresExtension = method.getAnnotation(WithPostgresExtension.class);
        if (postgresExtension != null) {
            PostgresExtensionUtils.dropExtension(this.getSink(), postgresExtension.value());
        }
    }
}

