/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.relational;

import io.debezium.util.Strings;
import java.util.Objects;

public class TableId {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    public TableId(String catalogName, String schemaName, String tableName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toFullIdentiferString() {
        if (this.catalogName != null && this.schemaName != null) {
            return this.catalogName + "." + this.schemaName + "." + this.tableName;
        }
        if (this.schemaName != null && this.tableName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public TableId toUpperCase() {
        return new TableId(Strings.isNullOrBlank((String)this.catalogName) ? this.catalogName : this.catalogName.toUpperCase(), Strings.isNullOrBlank((String)this.schemaName) ? this.schemaName : this.schemaName.toUpperCase(), Strings.isNullOrBlank((String)this.tableName) ? this.tableName : this.tableName.toUpperCase());
    }

    public TableId toLowerCase() {
        return new TableId(Strings.isNullOrBlank((String)this.catalogName) ? this.catalogName : this.catalogName.toLowerCase(), Strings.isNullOrBlank((String)this.schemaName) ? this.schemaName : this.schemaName.toLowerCase(), Strings.isNullOrBlank((String)this.tableName) ? this.tableName : this.tableName.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableId tableId = (TableId)o;
        return Objects.equals(this.catalogName, tableId.catalogName) && Objects.equals(this.schemaName, tableId.schemaName) && Objects.equals(this.tableName, tableId.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }
}

