/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.MappingException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.boot.model.process.internal.NamedBasicTypeResolution;
import org.hibernate.boot.model.process.internal.NamedConverterResolution;
import org.hibernate.boot.model.process.internal.UserTypeResolution;
import org.hibernate.boot.model.process.internal.VersionResolution;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;

public class BasicValue
extends SimpleValue
implements JdbcTypeIndicators,
Resolvable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(BasicValue.class);
    private final TypeConfiguration typeConfiguration;
    private String explicitTypeName;
    private Map<String, String> explicitLocalTypeParams;
    private Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess;
    private Function<TypeConfiguration, JdbcType> explicitJdbcTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private EnumType enumerationStyle;
    private TemporalType temporalPrecision;
    private TimeZoneStorageType timeZoneStorageType;
    private java.lang.reflect.Type resolvedJavaType;
    private String ownerName;
    private String propertyName;
    private Resolution<?> resolution;
    private static int COUNTER;

    public BasicValue(MetadataBuildingContext buildingContext) {
        this(buildingContext, null);
    }

    public BasicValue(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
        this.typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        buildingContext.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    public BasicValue(BasicValue original) {
        super(original);
        this.typeConfiguration = original.typeConfiguration;
        this.explicitTypeName = original.explicitTypeName;
        this.explicitLocalTypeParams = original.explicitLocalTypeParams == null ? null : new HashMap<String, String>(original.explicitLocalTypeParams);
        this.explicitJavaTypeAccess = original.explicitJavaTypeAccess;
        this.explicitJdbcTypeAccess = original.explicitJdbcTypeAccess;
        this.explicitMutabilityPlanAccess = original.explicitMutabilityPlanAccess;
        this.implicitJavaTypeAccess = original.implicitJavaTypeAccess;
        this.enumerationStyle = original.enumerationStyle;
        this.temporalPrecision = original.temporalPrecision;
        this.timeZoneStorageType = original.timeZoneStorageType;
        this.resolvedJavaType = original.resolvedJavaType;
        this.ownerName = original.ownerName;
        this.propertyName = original.propertyName;
    }

    @Override
    public BasicValue copy() {
        return new BasicValue(this);
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.resolution != null) {
            throw new IllegalStateException("BasicValue already resolved");
        }
        this.ownerName = className;
        this.propertyName = propertyName;
        super.setTypeUsingReflection(className, propertyName);
    }

    public void setEnumerationStyle(EnumType enumerationStyle) {
        this.enumerationStyle = enumerationStyle;
    }

    public EnumType getEnumerationStyle() {
        return this.enumerationStyle;
    }

    public TimeZoneStorageType getTimeZoneStorageType() {
        return this.timeZoneStorageType;
    }

    public void setTimeZoneStorageType(TimeZoneStorageType timeZoneStorageType) {
        this.timeZoneStorageType = timeZoneStorageType;
    }

    @Override
    public void setJpaAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.setAttributeConverterDescriptor(descriptor);
        super.setJpaAttributeConverterDescriptor(descriptor);
    }

    public void setExplicitJavaTypeAccess(Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess) {
        this.explicitJavaTypeAccess = explicitJavaTypeAccess;
    }

    public void setExplicitJdbcTypeAccess(Function<TypeConfiguration, JdbcType> jdbcTypeAccess) {
        this.explicitJdbcTypeAccess = jdbcTypeAccess;
    }

    public void setExplicitMutabilityPlanAccess(Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess) {
        this.explicitMutabilityPlanAccess = explicitMutabilityPlanAccess;
    }

    public void setImplicitJavaTypeAccess(Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess) {
        this.implicitJavaTypeAccess = implicitJavaTypeAccess;
    }

    public Selectable getColumn() {
        if (this.getColumnSpan() == 0) {
            return null;
        }
        return this.getColumn(0);
    }

    public java.lang.reflect.Type getResolvedJavaType() {
        return this.resolvedJavaType;
    }

    @Override
    public long getColumnLength() {
        Selectable column = this.getColumn();
        if (column instanceof Column) {
            Long length = ((Column)column).getLength();
            return length == null ? -1L : length;
        }
        return -1L;
    }

    @Override
    public int getColumnPrecision() {
        Selectable column = this.getColumn();
        if (column instanceof Column) {
            Integer length = ((Column)column).getPrecision();
            return length == null ? -1 : length;
        }
        return -1;
    }

    @Override
    public int getColumnScale() {
        Selectable column = this.getColumn();
        if (column instanceof Column) {
            Integer length = ((Column)column).getScale();
            return length == null ? -1 : length;
        }
        return -1;
    }

    @Override
    public void addColumn(Column incomingColumn) {
        super.addColumn(incomingColumn);
        this.checkSelectable(incomingColumn);
    }

    @Override
    public void copyTypeFrom(SimpleValue sourceValue) {
        super.copyTypeFrom(sourceValue);
        if (sourceValue instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)sourceValue;
            this.resolution = basicValue.resolution;
            this.implicitJavaTypeAccess = typeConfiguration -> basicValue.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
        }
    }

    private void checkSelectable(Selectable incomingColumn) {
        if (incomingColumn == null) {
            throw new IllegalArgumentException("Incoming column was null");
        }
        Selectable column = this.getColumn();
        if (column == incomingColumn || column.getText().equals(incomingColumn.getText())) {
            log.debugf("Skipping column re-registration: %s.%s", this.getTable().getName(), column.getText());
            return;
        }
    }

    @Override
    public void addColumn(Column incomingColumn, boolean isInsertable, boolean isUpdatable) {
        super.addColumn(incomingColumn, isInsertable, isUpdatable);
        this.checkSelectable(incomingColumn);
    }

    @Override
    public void addFormula(Formula formula) {
        super.addFormula(formula);
        this.checkSelectable(formula);
    }

    @Override
    public Type getType() throws MappingException {
        this.resolve();
        assert (this.getResolution() != null);
        return this.getResolution().getLegacyResolvedBasicType();
    }

    public Resolution<?> getResolution() {
        return this.resolution;
    }

    @Override
    public boolean resolve(MetadataBuildingContext buildingContext) {
        this.resolve();
        return true;
    }

    @Override
    public Resolution<?> resolve() {
        if (this.resolution != null) {
            return this.resolution;
        }
        this.resolution = this.buildResolution();
        if (this.resolution == null) {
            throw new IllegalStateException("Unable to resolve BasicValue : " + this);
        }
        Selectable column = this.getColumn();
        if (column instanceof Column && this.resolution.getValueConverter() == null) {
            Column physicalColumn = (Column)column;
            if (physicalColumn.getSqlTypeCode() == null) {
                physicalColumn.setSqlTypeCode(this.resolution.getJdbcType().getDefaultSqlTypeCode());
            }
            BasicType<?> basicType = this.resolution.getLegacyResolvedBasicType();
            Dialect dialect = this.getServiceRegistry().getService(JdbcServices.class).getDialect();
            String checkConstraint = physicalColumn.getCheckConstraint();
            if (checkConstraint == null && dialect.supportsColumnCheck()) {
                physicalColumn.setCheckConstraint(basicType.getJavaTypeDescriptor().getCheckCondition(physicalColumn.getQuotedName(dialect), basicType.getJdbcType(), dialect));
            }
        }
        return this.resolution;
    }

    protected Resolution<?> buildResolution() {
        ConverterDescriptor attributeConverterDescriptor;
        JavaType<?> reflectedJtd;
        java.lang.reflect.Type implicitJtd;
        BasicJavaType explicitJtd;
        Properties typeParameters = this.getTypeParameters();
        if (typeParameters != null && Boolean.parseBoolean(typeParameters.getProperty("org.hibernate.type.ParameterType.dynamic")) && typeParameters.get("org.hibernate.type.ParameterType") == null) {
            this.createParameterImpl();
        }
        if (this.explicitTypeName != null) {
            return BasicValue.interpretExplicitlyNamedType(this.explicitTypeName, this.enumerationStyle, this.implicitJavaTypeAccess, this.explicitJavaTypeAccess, this.explicitJdbcTypeAccess, this.explicitMutabilityPlanAccess, this.getAttributeConverterDescriptor(), typeParameters, this::setTypeParameters, this, this.typeConfiguration, this.getBuildingContext());
        }
        if (this.isVersion()) {
            return VersionResolution.from(this.implicitJavaTypeAccess, this.explicitJavaTypeAccess, this.explicitJdbcTypeAccess, this.timeZoneStorageType, this.typeConfiguration, this.getBuildingContext());
        }
        BasicJavaType jtd = null;
        if (this.explicitJavaTypeAccess != null) {
            explicitJtd = this.explicitJavaTypeAccess.apply(this.typeConfiguration);
            if (explicitJtd != null) {
                jtd = explicitJtd;
            }
        } else {
            explicitJtd = null;
        }
        if (jtd == null && this.implicitJavaTypeAccess != null && (implicitJtd = this.implicitJavaTypeAccess.apply(this.typeConfiguration)) != null) {
            jtd = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(implicitJtd);
        }
        if (jtd == null && (reflectedJtd = this.determineReflectedJavaType()) != null) {
            jtd = reflectedJtd;
        }
        if ((attributeConverterDescriptor = this.getAttributeConverterDescriptor()) != null) {
            final ManagedBeanRegistry managedBeanRegistry = this.getBuildingContext().getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
            JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

                @Override
                public ManagedBeanRegistry getManagedBeanRegistry() {
                    return managedBeanRegistry;
                }

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return BasicValue.this.typeConfiguration;
                }
            };
            NamedConverterResolution converterResolution = NamedConverterResolution.from(attributeConverterDescriptor, this.explicitJavaTypeAccess, this.explicitJdbcTypeAccess, this.explicitMutabilityPlanAccess, (JdbcTypeIndicators)this, converterCreationContext, this.getBuildingContext());
            if (jtd instanceof BasicPluralJavaType && !attributeConverterDescriptor.getDomainValueResolvedType().getErasedType().isAssignableFrom(jtd.getJavaTypeClass())) {
                BasicType<?> registeredType;
                BasicPluralJavaType containerJtd = (BasicPluralJavaType)((Object)jtd);
                BasicType registeredElementType = converterResolution.getLegacyResolvedBasicType();
                ColumnTypeInformation columnTypeInformation = this.getColumn() instanceof ColumnTypeInformation ? (ColumnTypeInformation)((Object)this.getColumn()) : null;
                BasicType<?> basicType = registeredType = registeredElementType == null ? null : containerJtd.resolveType(this.typeConfiguration, this.getMetadata().getDatabase().getDialect(), registeredElementType, columnTypeInformation);
                if (registeredType != null) {
                    this.typeConfiguration.getBasicTypeRegistry().register(registeredType);
                    return new InferredBasicValueResolution(registeredType, registeredType.getJavaTypeDescriptor(), registeredType.getJavaTypeDescriptor(), registeredType.getJdbcType(), registeredType, null);
                }
            }
            return converterResolution;
        }
        JdbcType jdbcType = this.explicitJdbcTypeAccess != null ? this.explicitJdbcTypeAccess.apply(this.typeConfiguration) : null;
        if (jtd == null && jdbcType != null) {
            jtd = jdbcType.getJdbcRecommendedJavaTypeMapping(null, null, this.typeConfiguration);
        }
        if (jtd == null) {
            throw new MappingException("Unable to determine JavaType to use : " + this);
        }
        TypeDefinitionRegistry typeDefinitionRegistry = this.getBuildingContext().getTypeDefinitionRegistry();
        TypeDefinition autoAppliedTypeDef = typeDefinitionRegistry.resolveAutoApplied(jtd);
        if (!(autoAppliedTypeDef == null || jtd.getJavaTypeClass().isEnum() && this.enumerationStyle != null)) {
            log.debug("BasicValue resolution matched auto-applied type-definition");
            return autoAppliedTypeDef.resolve(typeParameters, null, this.getBuildingContext(), this);
        }
        return InferredBasicValueResolver.from(explicitJtd, jdbcType, this.resolvedJavaType, this::determineReflectedJavaType, this, this.getTable(), this.getColumn(), this.ownerName, this.propertyName, this.getMetadata().getDatabase().getDialect(), this.typeConfiguration);
    }

    private JavaType<?> determineReflectedJavaType() {
        java.lang.reflect.Type impliedJavaType;
        if (this.resolvedJavaType != null) {
            impliedJavaType = this.resolvedJavaType;
        } else if (this.implicitJavaTypeAccess != null) {
            impliedJavaType = this.implicitJavaTypeAccess.apply(this.typeConfiguration);
        } else if (this.ownerName != null && this.propertyName != null) {
            ServiceRegistry serviceRegistry = this.typeConfiguration.getServiceRegistry();
            ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
            impliedJavaType = ReflectHelper.reflectedPropertyType(this.ownerName, this.propertyName, classLoaderService);
        } else {
            return null;
        }
        this.resolvedJavaType = impliedJavaType;
        if (impliedJavaType == null) {
            return null;
        }
        return this.typeConfiguration.getJavaTypeRegistry().resolveDescriptor(impliedJavaType);
    }

    private static Resolution<?> interpretExplicitlyNamedType(String name, EnumType enumerationStyle, Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaType> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, ConverterDescriptor converterDescriptor, Map<Object, Object> localTypeParams, Consumer<Properties> combinedParameterConsumer, JdbcTypeIndicators stdIndicators, final TypeConfiguration typeConfiguration, MetadataBuildingContext context) {
        StandardServiceRegistry serviceRegistry = context.getBootstrapContext().getServiceRegistry();
        final ManagedBeanRegistry managedBeanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
        JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return managedBeanRegistry;
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }
        };
        if (name.startsWith("converted::")) {
            return NamedConverterResolution.from(name, explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, stdIndicators, converterCreationContext, context);
        }
        if (name.startsWith("basicType")) {
            BasicTypeImpl basicType = context.getBootstrapContext().resolveAdHocBasicType(name);
            return new NamedBasicTypeResolution(basicType.getJavaTypeDescriptor(), basicType, null, explicitMutabilityPlanAccess, context);
        }
        BasicType basicTypeByName = typeConfiguration.getBasicTypeRegistry().getRegisteredType(name);
        if (basicTypeByName != null) {
            JavaType domainJtd;
            BasicValueConverter valueConverter;
            if (converterDescriptor != null) {
                valueConverter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
                domainJtd = valueConverter.getDomainJavaType();
            } else {
                valueConverter = basicTypeByName.getValueConverter();
                domainJtd = basicTypeByName.getJavaTypeDescriptor();
            }
            return new NamedBasicTypeResolution(domainJtd, basicTypeByName, valueConverter, explicitMutabilityPlanAccess, context);
        }
        TypeDefinition typeDefinition = context.getTypeDefinitionRegistry().resolve(name);
        if (typeDefinition != null) {
            Resolution<?> resolution = typeDefinition.resolve(localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context, stdIndicators);
            combinedParameterConsumer.accept(resolution.getCombinedTypeParameters());
            return resolution;
        }
        ClassLoaderService cls = typeConfiguration.getServiceRegistry().getService(ClassLoaderService.class);
        try {
            Class typeNamedClass = cls.classForName(name);
            if (CollectionHelper.isEmpty(localTypeParams)) {
                TypeDefinition implicitDefinition = new TypeDefinition(name, typeNamedClass, null, null);
                context.getTypeDefinitionRegistry().register(implicitDefinition);
                return implicitDefinition.resolve(localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context, stdIndicators);
            }
            return TypeDefinition.createLocalResolution(name, typeNamedClass, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, localTypeParams, context);
        }
        catch (ClassLoadingException e) {
            log.debugf("Could not resolve type-name [%s] as Java type : %s", name, (Object)e);
            throw new MappingException("Could not resolve named type : " + name);
        }
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getEnumerationStyle();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.getBuildingContext().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.getBuildingContext().getPreferredSqlTypeCodeForDuration();
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.getBuildingContext().getPreferredSqlTypeCodeForUuid();
    }

    @Override
    public int getPreferredSqlTypeCodeForInstant() {
        return this.getBuildingContext().getPreferredSqlTypeCodeForInstant();
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return this.getBuildingContext().getPreferredSqlTypeCodeForArray();
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        if (this.timeZoneStorageType != null) {
            switch (this.timeZoneStorageType) {
                case COLUMN: {
                    return TimeZoneStorageStrategy.COLUMN;
                }
                case NATIVE: {
                    return TimeZoneStorageStrategy.NATIVE;
                }
                case NORMALIZE: {
                    return TimeZoneStorageStrategy.NORMALIZE;
                }
                case NORMALIZE_UTC: {
                    return TimeZoneStorageStrategy.NORMALIZE_UTC;
                }
            }
        }
        return this.getBuildingContext().getBuildingOptions().getDefaultTimeZoneStorage();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setExplicitTypeParams(Map<String, String> explicitLocalTypeParams) {
        this.explicitLocalTypeParams = explicitLocalTypeParams;
    }

    public void setExplicitTypeName(String typeName) {
        this.explicitTypeName = typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        if (StringHelper.isNotEmpty(typeName)) {
            if (typeName.startsWith("converted::")) {
                String converterClassName = typeName.substring("converted::".length());
                ClassLoaderService cls = this.getBuildingContext().getMetadataCollector().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
                try {
                    Class converterClass = cls.classForName(converterClassName);
                    this.setAttributeConverterDescriptor(new ClassBasedConverterDescriptor(converterClass, false, this.getBuildingContext().getBootstrapContext().getClassmateContext()));
                    return;
                }
                catch (Exception e) {
                    log.logBadHbmAttributeConverterType(typeName, e.getMessage());
                }
            } else {
                this.setExplicitTypeName(typeName);
            }
        }
        super.setTypeName(typeName);
    }

    public <T extends UserType<?>> void setExplicitCustomType(Class<T> explicitCustomType) {
        if (explicitCustomType != null) {
            ManagedBean<T> typeBean;
            if (this.resolution != null) {
                throw new UnsupportedOperationException("Unsupported attempt to set an explicit-custom-type when value is already resolved");
            }
            BootstrapContext bootstrapContext = this.getBuildingContext().getBootstrapContext();
            BeanInstanceProducer instanceProducer = bootstrapContext.getBeanInstanceProducer();
            Properties properties = new Properties();
            if (CollectionHelper.isNotEmpty(this.getTypeParameters())) {
                properties.putAll((Map<?, ?>)this.getTypeParameters());
            }
            if (CollectionHelper.isNotEmpty(this.explicitLocalTypeParams)) {
                properties.putAll(this.explicitLocalTypeParams);
            }
            if (properties.isEmpty()) {
                typeBean = bootstrapContext.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(explicitCustomType, instanceProducer);
            } else {
                String name = explicitCustomType.getName() + COUNTER++;
                typeBean = bootstrapContext.getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(name, explicitCustomType, instanceProducer);
            }
            UserType typeInstance = (UserType)typeBean.getBeanInstance();
            if (typeInstance instanceof TypeConfigurationAware) {
                ((TypeConfigurationAware)((Object)typeInstance)).setTypeConfiguration(this.typeConfiguration);
            }
            if (typeInstance instanceof DynamicParameterizedType && Boolean.parseBoolean(properties.getProperty("org.hibernate.type.ParameterType.dynamic")) && properties.get("org.hibernate.type.ParameterType") == null) {
                DynamicParameterizedType.ParameterType parameterType = this.makeParameterImpl();
                properties.put("org.hibernate.type.ParameterType", parameterType);
            }
            MappingHelper.injectParameters((Object)typeInstance, properties);
            this.setTypeParameters(properties);
            this.resolution = new UserTypeResolution(new CustomType(typeInstance, this.typeConfiguration), null, properties);
        }
    }

    public void setTemporalPrecision(TemporalType temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    public static interface Resolution<J> {
        public BasicType<J> getLegacyResolvedBasicType();

        default public Properties getCombinedTypeParameters() {
            return null;
        }

        public JdbcMapping getJdbcMapping();

        public JavaType<J> getDomainJavaType();

        public JavaType<?> getRelationalJavaType();

        public JdbcType getJdbcType();

        public BasicValueConverter<J, ?> getValueConverter();

        public MutabilityPlan<J> getMutabilityPlan();
    }
}

