/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.integration.postgres;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.integration.AbstractJdbcSinkTest;
import io.debezium.connector.jdbc.junit.TestHelper;
import io.debezium.connector.jdbc.junit.jupiter.PostgresSinkDatabaseContextProvider;
import io.debezium.connector.jdbc.junit.jupiter.Sink;
import io.debezium.connector.jdbc.junit.jupiter.SinkRecordFactoryArgumentsProvider;
import io.debezium.connector.jdbc.util.SinkRecordFactory;
import io.debezium.doc.FixFor;
import java.util.Map;
import org.apache.kafka.connect.sink.SinkRecord;
import org.assertj.db.api.TableAssert;
import org.assertj.db.api.TableColumnAssert;
import org.assertj.db.api.TableColumnValueAssert;
import org.assertj.db.type.ValueType;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tags(value={@Tag(value="all"), @Tag(value="it"), @Tag(value="it-postgresql")})
@ExtendWith(value={PostgresSinkDatabaseContextProvider.class})
public class JdbcSinkFieldFilterIT
extends AbstractJdbcSinkTest {
    public JdbcSinkFieldFilterIT(Sink sink) {
        super(sink);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6636"})
    public void testFieldIncludeListWithInsertMode(SinkRecordFactory factory) throws Exception {
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        properties.put("field.include.list", topicName + ":name," + topicName + ":id");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableColumnValueAssert)((TableColumnAssert)tableAssert.exists().column("id")).value()).isEqualTo((Number)1);
        ((TableColumnValueAssert)((TableColumnAssert)tableAssert.exists().column("name")).value()).isEqualTo("John Doe");
        tableAssert.exists().hasNumberOfColumns(2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6636"})
    public void testFieldExcludeListWithInsertMode(SinkRecordFactory factory) throws Exception {
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.INSERT.getValue());
        properties.put("field.exclude.list", topicName + ":name");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        SinkRecord createRecord = factory.createRecordNoKey(topicName);
        this.consume(createRecord);
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        tableAssert.exists().hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, 1);
        this.getSink().assertColumnType(tableAssert, "nick_name$", ValueType.TEXT, "John Doe$");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SinkRecordFactoryArgumentsProvider.class)
    @FixFor(value={"DBZ-6636"})
    public void testFieldIncludeListWithUpsertMode(SinkRecordFactory factory) throws Exception {
        String tableName = this.randomTableName();
        String topicName = this.topicName("server1", "schema", tableName);
        Map<String, String> properties = this.getDefaultSinkConfig();
        properties.put("schema.evolution", JdbcSinkConnectorConfig.SchemaEvolutionMode.BASIC.getValue());
        properties.put("primary.key.mode", JdbcSinkConnectorConfig.PrimaryKeyMode.RECORD_VALUE.getValue());
        properties.put("primary.key.fields", "id");
        properties.put("insert.mode", JdbcSinkConnectorConfig.InsertMode.UPSERT.getValue());
        properties.put("field.include.list", topicName + ":name," + topicName + ":id");
        this.startSinkConnector(properties);
        this.assertSinkConnectorIsRunning();
        SinkRecord createRecord = factory.createRecord(topicName, (byte)1);
        this.consume(createRecord);
        this.consume(factory.createRecord(topicName, (byte)1));
        TableAssert tableAssert = TestHelper.assertTable(this.dataSource(), this.destinationTableName(createRecord));
        ((TableAssert)tableAssert.exists().hasNumberOfRows(1)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssert, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssert, "name", ValueType.TEXT, "John Doe");
        SinkRecord updateRecord = factory.updateRecord(topicName);
        this.consume(updateRecord);
        TableAssert tableAssertForUpdate = TestHelper.assertTable(this.dataSource(), this.destinationTableName(updateRecord));
        ((TableAssert)tableAssertForUpdate.exists().hasNumberOfRows(1)).hasNumberOfColumns(2);
        this.getSink().assertColumnType(tableAssertForUpdate, "id", ValueType.NUMBER, (byte)1);
        this.getSink().assertColumnType(tableAssertForUpdate, "name", ValueType.TEXT, "Jane Doe");
    }
}

