/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.db2.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.db2.debezium.AbstractDebeziumTimestampType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.kafka.connect.data.Schema;

public class TimestampType
extends AbstractDebeziumTimestampType {
    public static final TimestampType INSTANCE = new TimestampType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.Timestamp"};
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedDateTime(Instant.ofEpochMilli((Long)value).atZone(ZoneOffset.UTC));
    }

    @Override
    protected LocalDateTime getLocalDateTime(long value) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC);
    }
}

