/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.config.spi;

import org.hibernate.engine.config.spi.ConfigurationService;

public class StandardConverters {
    public static final ConfigurationService.Converter<Boolean> BOOLEAN = StandardConverters::asBoolean;
    public static final ConfigurationService.Converter<String> STRING = StandardConverters::asString;
    public static final ConfigurationService.Converter<Integer> INTEGER = StandardConverters::asInteger;

    public static Boolean asBoolean(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value passed to convert");
        }
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
    }

    public static String asString(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value passed to convert");
        }
        return value.toString();
    }

    public static Integer asInteger(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value passed to convert");
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private StandardConverters() {
    }
}

