/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.sqlserver;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import java.math.BigInteger;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.engine.jdbc.Size;

class BitType
extends AbstractType {
    public static final BitType INSTANCE = new BitType();

    BitType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Bits"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        if ("io.debezium.data.Bits".equals(schema.name())) {
            int bitSize = Integer.parseInt((String)schema.parameters().get("length"));
            return String.format("cast(? as %s)", bitSize > 1 ? String.format("varbinary(%d)", bitSize) : "bit");
        }
        return "cast(? as varbinary)";
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return String.format(dialect.getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        if ("io.debezium.data.Bits".equals(schema.name())) {
            int bitSize = Integer.parseInt((String)schema.parameters().get("length"));
            if (bitSize == 1) {
                return dialect.getTypeName(-7);
            }
            return dialect.getTypeName(-3, Size.length((long)bitSize));
        }
        return dialect.getTypeName(-3);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof byte[]) {
            BigInteger bigIntegerValue = new BigInteger((byte[])value);
            return List.of(new ValueBindDescriptor(index, bigIntegerValue.intValue()));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

