/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.time.ZonedTime;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.engine.jdbc.Size;

public class ZonedTimeType
extends AbstractTimeType {
    public static final ZonedTimeType INSTANCE = new ZonedTimeType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTime"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        int precision = this.getTimePrecision(schema);
        if (precision > 0) {
            return dialect.getTypeName(this.getJdbcType(), Size.precision((int)precision));
        }
        return dialect.getTypeName(this.getJdbcType(), Size.precision((int)dialect.getMaxTimePrecision()));
    }

    @Override
    public String getDefaultValueBinding(DatabaseDialect dialect, Schema schema, Object value) {
        return dialect.getFormattedTimeWithTimeZone((String)value);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof String) {
            ZonedDateTime zdt = OffsetTime.parse((String)value, ZonedTime.FORMATTER).atDate(LocalDate.now()).toZonedDateTime();
            if (this.getDialect().isTimeZoneSet()) {
                if (this.getDialect().shouldBindTimeWithTimeZoneAsDatabaseTimeZone()) {
                    return List.of(new ValueBindDescriptor(index, zdt.withZoneSameInstant(this.getDatabaseTimeZone().toZoneId()).toOffsetDateTime()));
                }
                return List.of(new ValueBindDescriptor(index, zdt.toOffsetDateTime(), this.getJdbcType()));
            }
            return List.of(new ValueBindDescriptor(index, zdt.toOffsetDateTime()));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }

    protected int getJdbcType() {
        return 2013;
    }
}

