/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.converters.spi.CloudEventsValidator;
import io.debezium.converters.spi.SerializerType;
import io.debezium.transforms.outbox.AdditionalFieldsValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertCloudEventToSaveableForm
implements Transformation<SinkRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertCloudEventToSaveableForm.class);
    private static final String FIELD_NAME_SEPARATOR = ":";
    private static final Field FIELDS_MAPPING = Field.create((String)"fields.mapping").withDisplayName("Specifies a list of pairs with mappings between a CloudEvent's fields and names of database columns").withType(ConfigDef.Type.LIST).withValidation(new Field.Validator[]{AdditionalFieldsValidator::isListOfStringPairs}).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Specifies a list of pairs with mappings between a CloudEvent's fields and names of database columns");
    private static final Field SERIALIZER_TYPE = Field.create((String)"serializer.type").withDisplayName("Specifies a serialization type a provided CloudEvent was serialized and deserialized with").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Specifies a serialization type a provided CloudEvent was serialized and deserialized with");
    private static final Field CLOUDEVENTS_SCHEMA_NAME = Field.create((String)"schema.cloudevents.name").withDisplayName("Specifies CloudEvents schema name under which the schema is registered in a Schema Registry").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Specifies CloudEvents schema name under which the schema is registered in a Schema Registry");
    private Map<String, String> fieldsMapping;
    private SerializerType serializerType;
    private String cloudEventsSchemaName;
    private final JsonConverter jsonDataConverter = new JsonConverter();
    private final Map<String, Schema> cloudEventsFieldToColumnSchema = new HashMap<String, Schema>();
    private final CloudEventsValidator cloudEventsValidator = new CloudEventsValidator();

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, null, (Field[])new Field[]{FIELDS_MAPPING, SERIALIZER_TYPE});
        return config;
    }

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        List rawFieldsMapping = config.getList(FIELDS_MAPPING);
        this.fieldsMapping = Collections.unmodifiableMap(this.parseFieldsMapping(rawFieldsMapping));
        this.serializerType = SerializerType.withName((String)config.getString(SERIALIZER_TYPE));
        if (this.serializerType == null) {
            throw new ConfigException(SERIALIZER_TYPE.name(), (Object)this.serializerType, "Serialization/deserialization type of CloudEvents converter is required");
        }
        this.cloudEventsSchemaName = config.getString(CLOUDEVENTS_SCHEMA_NAME);
        HashMap<String, Object> jsonDataConverterConfig = new HashMap<String, Object>();
        jsonDataConverterConfig.put("schemas.enable", false);
        jsonDataConverterConfig.put("converter.type", "value");
        this.jsonDataConverter.configure(jsonDataConverterConfig);
        this.cloudEventsFieldToColumnSchema.put("id", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("source", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("specversion", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("type", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("datacontenttype", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("dataschema", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("time", Schema.STRING_SCHEMA);
        this.cloudEventsFieldToColumnSchema.put("data", Schema.STRING_SCHEMA);
        this.cloudEventsValidator.configure(this.serializerType, this.cloudEventsSchemaName);
    }

    private Map<String, String> parseFieldsMapping(List<String> rawFieldsMapping) {
        HashMap<String, String> parsedFieldsMapping = new HashMap<String, String>();
        for (String rawFieldMapping : rawFieldsMapping) {
            String[] parts = rawFieldMapping.split(FIELD_NAME_SEPARATOR);
            String cloudEventFieldName = parts[0];
            String databaseColumnName = parts.length > 1 ? parts[1] : cloudEventFieldName;
            parsedFieldsMapping.put(cloudEventFieldName, databaseColumnName);
        }
        return parsedFieldsMapping;
    }

    public SinkRecord apply(SinkRecord record) {
        boolean cloudEventContainsDataAsStruct;
        if (record == null || !this.cloudEventsValidator.isCloudEvent(new SchemaAndValue(record.valueSchema(), record.value())) || this.fieldsMapping.isEmpty()) {
            return record;
        }
        if (this.serializerType == SerializerType.JSON) {
            Object dataFieldValue = this.getCloudEventFieldsMap(record).get("data");
            cloudEventContainsDataAsStruct = dataFieldValue instanceof Struct;
        } else {
            org.apache.kafka.connect.data.Field dataField = record.valueSchema().field("data");
            cloudEventContainsDataAsStruct = dataField != null && dataField.schema().type() == Schema.Type.STRUCT;
        }
        Schema newSchema = this.getSchema(record, cloudEventContainsDataAsStruct);
        Struct newValue = this.getValue(record, newSchema, cloudEventContainsDataAsStruct);
        return record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), newSchema, (Object)newValue, record.timestamp(), (Iterable)record.headers());
    }

    private Map<String, Object> getCloudEventFieldsMap(SinkRecord record) {
        return (Map)record.value();
    }

    private Schema getSchema(SinkRecord record, boolean cloudEventContainsDataAsStruct) {
        Map<String, Object> cloudEventMap = null;
        if (this.serializerType == SerializerType.JSON) {
            cloudEventMap = this.getCloudEventFieldsMap(record);
        }
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        for (Map.Entry<String, String> fieldMapping : this.fieldsMapping.entrySet()) {
            Schema cloudEventFieldSchema;
            String cloudEventFieldName = fieldMapping.getKey();
            String databaseColumnName = fieldMapping.getValue();
            if (this.serializerType == SerializerType.JSON) {
                Object cloudEventFieldValue = cloudEventMap.get(cloudEventFieldName);
                cloudEventFieldSchema = cloudEventFieldValue == null ? this.cloudEventsFieldToColumnSchema.get(cloudEventFieldName) : this.determineCloudEventFieldSchema(cloudEventFieldValue);
            } else {
                org.apache.kafka.connect.data.Field cloudEventField = record.valueSchema().field(cloudEventFieldName);
                cloudEventFieldSchema = cloudEventField.schema();
            }
            Schema databaseColumnSchema = cloudEventFieldName.equals("data") && cloudEventContainsDataAsStruct ? Schema.STRING_SCHEMA : cloudEventFieldSchema;
            schemaBuilder.field(databaseColumnName, databaseColumnSchema);
        }
        return schemaBuilder.build();
    }

    private Schema determineCloudEventFieldSchema(Object cloudEventFieldValue) {
        Schema cloudEventFieldSchema;
        if (cloudEventFieldValue instanceof String) {
            cloudEventFieldSchema = Schema.STRING_SCHEMA;
        } else if (cloudEventFieldValue instanceof Struct) {
            cloudEventFieldSchema = ((Struct)cloudEventFieldValue).schema();
        } else {
            throw new DataException("Unsupported type of CloudEvent field: " + cloudEventFieldValue.getClass());
        }
        return cloudEventFieldSchema;
    }

    private Struct getValue(SinkRecord record, Schema schema, boolean cloudEventContainsDataAsStruct) {
        Map<String, Object> cloudEventMap = null;
        Struct cloudEventStruct = null;
        if (this.serializerType == SerializerType.JSON) {
            cloudEventMap = this.getCloudEventFieldsMap(record);
        } else {
            cloudEventStruct = Requirements.requireStruct((Object)record.value(), (String)"convert cloud event");
        }
        Struct struct = new Struct(schema);
        for (Map.Entry<String, String> fieldMapping : this.fieldsMapping.entrySet()) {
            String cloudEventFieldName = fieldMapping.getKey();
            String databaseColumnName = fieldMapping.getValue();
            Object fieldValue = this.serializerType == SerializerType.JSON ? cloudEventMap.get(cloudEventFieldName) : cloudEventStruct.get(cloudEventFieldName);
            if (cloudEventFieldName.equals("data") && cloudEventContainsDataAsStruct) {
                Struct data = (Struct)fieldValue;
                byte[] dataInJson = this.jsonDataConverter.fromConnectData(null, data.schema(), (Object)data);
                fieldValue = new String(dataInJson);
            }
            struct.put(databaseColumnName, fieldValue);
        }
        return struct;
    }

    public void close() {
    }
}

